/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

public abstract class Controller
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract boolean writeLog(FilePath var1, OutputStream var2) throws IOException, InterruptedException;

    @CheckForNull
    public Integer exitStatus(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        if (Util.isOverridden(Controller.class, this.getClass(), (String)"exitStatus", (Class[])new Class[]{FilePath.class})) {
            return this.exitStatus(workspace);
        }
        throw new AbstractMethodError("implement exitStatus(FilePath, Launcher)");
    }

    @CheckForNull
    public Integer exitStatus(FilePath workspace) throws IOException, InterruptedException {
        return this.exitStatus(workspace, Controller.createLauncher(workspace));
    }

    public void stop(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        if (!Util.isOverridden(Controller.class, this.getClass(), (String)"stop", (Class[])new Class[]{FilePath.class})) {
            throw new AbstractMethodError("implement stop(FilePath, Launcher)");
        }
        this.stop(workspace);
    }

    public void stop(FilePath workspace) throws IOException, InterruptedException {
        this.stop(workspace, Controller.createLauncher(workspace));
    }

    private static Launcher createLauncher(FilePath workspace) throws IOException, InterruptedException {
        return workspace.createLauncher((TaskListener)new LogTaskListener(Logger.getLogger(Controller.class.getName()), Level.FINE));
    }

    public abstract void cleanup(FilePath var1) throws IOException, InterruptedException;
}

