/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.credentials;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialContext;
import org.jenkinsci.plugins.docker.commons.impl.CompositeKeyMaterialFactory;
import org.jenkinsci.plugins.docker.commons.impl.NullKeyMaterialFactory;

public abstract class KeyMaterialFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final KeyMaterialFactory NULL = new NullKeyMaterialFactory();
    private KeyMaterialContext context;

    protected synchronized void checkContextualized() {
        if (this.context == null) {
            throw new IllegalStateException("KeyMaterialFactories must be contextualized before use");
        }
    }

    public synchronized KeyMaterialFactory contextualize(@Nonnull KeyMaterialContext context) {
        if (this.context != null) {
            throw new IllegalStateException("KeyMaterialFactories cannot be re-contextualized");
        }
        this.context = context;
        return this;
    }

    @Nonnull
    protected synchronized KeyMaterialContext getContext() {
        this.checkContextualized();
        return this.context;
    }

    public abstract KeyMaterial materialize() throws IOException, InterruptedException;

    public KeyMaterialFactory plus(KeyMaterialFactory ... factories) {
        if (factories == null || factories.length == 0) {
            return this;
        }
        ArrayList<KeyMaterialFactory> tmp = new ArrayList<KeyMaterialFactory>(factories.length + 1);
        tmp.add(this);
        for (KeyMaterialFactory f : factories) {
            if (f == null) continue;
            tmp.add(f);
        }
        return new CompositeKeyMaterialFactory(tmp.toArray(new KeyMaterialFactory[tmp.size()]));
    }
}

