/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.Messages;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ManagementLink;
import hudson.model.ModelObject;
import hudson.model.Saveable;
import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class SystemCredentialsProvider
extends ManagementLink
implements Describable<SystemCredentialsProvider>,
Saveable,
StaplerProxy {
    private static final Logger LOGGER = Logger.getLogger(SystemCredentialsProvider.class.getName());
    private List<Credentials> credentials = new ArrayList<Credentials>();

    public SystemCredentialsProvider() {
        try {
            XmlFile xml = SystemCredentialsProvider.getConfigFile();
            if (xml.exists()) {
                xml.unmarshal((Object)this);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to read the existing credentials", e);
        }
    }

    public String getIconFileName() {
        return CredentialsProvider.allCredentialsDescriptors().isEmpty() ? null : "/plugin/credentials/images/48x48/credentials.png";
    }

    public String getDisplayName() {
        return Messages.SystemCredentialsProvider_DisplayName();
    }

    public String getDescription() {
        return Messages.SystemCredentialsProvider_Description();
    }

    public String getUrlName() {
        return "credentials";
    }

    public List<Credentials> getCredentials() {
        return this.credentials;
    }

    public DescriptorExtensionList<Credentials, Descriptor<Credentials>> getCredentialDescriptors() {
        return CredentialsProvider.allCredentialsDescriptors();
    }

    public Descriptor<SystemCredentialsProvider> getDescriptor() {
        return Hudson.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public Object getTarget() {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        return this;
    }

    public HttpResponse doConfigSubmit(StaplerRequest req) throws ServletException, IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        JSONObject data = req.getSubmittedForm();
        this.credentials = req.bindJSONToList(Credentials.class, data.get("credentials"));
        this.save();
        return HttpResponses.redirectToContextRoot();
    }

    public void save() throws IOException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        SystemCredentialsProvider.getConfigFile().write((Object)this);
    }

    public static XmlFile getConfigFile() {
        return new XmlFile(new File(Hudson.getInstance().getRootDir(), "credentials.xml"));
    }

    public static SystemCredentialsProvider getInstance() {
        return (SystemCredentialsProvider)((Object)SystemCredentialsProvider.all().get(SystemCredentialsProvider.class));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ProviderImpl
    extends CredentialsProvider {
        private static final Set<CredentialsScope> SCOPES = Collections.unmodifiableSet(new LinkedHashSet<CredentialsScope>(Arrays.asList(CredentialsScope.GLOBAL, CredentialsScope.SYSTEM)));

        @Override
        public Set<CredentialsScope> getScopes(ModelObject object) {
            if (object instanceof Hudson || object instanceof SystemCredentialsProvider) {
                return SCOPES;
            }
            return super.getScopes(object);
        }

        @Override
        @NonNull
        public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication) {
            boolean includeSystemScope;
            ArrayList<C> result = new ArrayList<C>();
            boolean bl = includeSystemScope = Hudson.getInstance() == itemGroup;
            if (ACL.SYSTEM.equals(authentication)) {
                for (Credentials credential : SystemCredentialsProvider.getInstance().getCredentials()) {
                    if (!type.isInstance(credential) || !includeSystemScope && CredentialsScope.SYSTEM.equals(credential.getScope())) continue;
                    result.add(type.cast(credential));
                }
            }
            return result;
        }

        @Override
        @NonNull
        public <C extends Credentials> List<C> getCredentials(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication) {
            ArrayList<C> result = new ArrayList<C>();
            if (ACL.SYSTEM.equals(authentication)) {
                for (Credentials credential : SystemCredentialsProvider.getInstance().getCredentials()) {
                    if (!type.isInstance(credential) || CredentialsScope.SYSTEM.equals(credential.getScope())) continue;
                    result.add(type.cast(credential));
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SystemCredentialsProvider> {
        public String getDisplayName() {
            return "";
        }
    }
}

