/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.impl;

import com.cloudbees.plugins.credentials.BaseCredentials;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class BaseStandardCredentials
extends BaseCredentials
implements StandardCredentials {
    @NonNull
    private final String id;
    @NonNull
    private final String description;

    public BaseStandardCredentials(@CheckForNull String id, @CheckForNull String description) {
        this.id = IdCredentials.Helpers.fixEmptyId(id);
        this.description = Util.fixNull((String)description);
    }

    public BaseStandardCredentials(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description) {
        super(scope);
        this.id = IdCredentials.Helpers.fixEmptyId(id);
        this.description = Util.fixNull((String)description);
    }

    @Exported
    @NonNull
    public String getDescription() {
        return this.description;
    }

    @Exported
    @NonNull
    public String getId() {
        return this.id;
    }

    public final boolean equals(Object o) {
        return IdCredentials.Helpers.equals(this, o);
    }

    public final int hashCode() {
        return IdCredentials.Helpers.hashCode(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class BaseStandardCredentialsDescriptor
    extends CredentialsDescriptor {
        protected BaseStandardCredentialsDescriptor() {
            this.clazz.asSubclass(BaseStandardCredentials.class);
        }

        protected BaseStandardCredentialsDescriptor(Class<? extends BaseStandardCredentials> clazz) {
            super(clazz);
        }

        public final FormValidation doCheckId(@QueryParameter String value, @AncestorInPath ModelObject context) {
            Jenkins j;
            User me;
            if (value.isEmpty()) {
                return FormValidation.ok();
            }
            if (!value.matches("[a-zA-Z0-9_.-]+")) {
                return FormValidation.error((String)"Unacceptable characters");
            }
            FormValidation problem = BaseStandardCredentialsDescriptor.checkForDuplicates(value, context, context);
            if (problem != null) {
                return problem;
            }
            if (!(context instanceof User) && (me = User.current()) != null && (problem = BaseStandardCredentialsDescriptor.checkForDuplicates(value, context, (ModelObject)me)) != null) {
                return problem;
            }
            if (!(context instanceof Jenkins) && (j = Jenkins.getInstance()) != null && (problem = BaseStandardCredentialsDescriptor.checkForDuplicates(value, context, (ModelObject)j)) != null) {
                return problem;
            }
            return FormValidation.ok();
        }

        @CheckForNull
        private static FormValidation checkForDuplicates(String value, ModelObject context, ModelObject object) {
            for (CredentialsStore store : CredentialsProvider.lookupStores(object)) {
                if (!store.hasPermission(CredentialsProvider.VIEW)) continue;
                ModelObject storeContext = store.getContext();
                for (Domain domain : store.getDomains()) {
                    if (CredentialsMatchers.firstOrNull(store.getCredentials(domain), CredentialsMatchers.withId(value)) == null) continue;
                    if (storeContext == context) {
                        return FormValidation.error((String)"This ID is already in use");
                    }
                    return FormValidation.warning((String)"The ID \u2018%s\u2019 is already in use in %s", (Object[])new Object[]{value, storeContext instanceof Item ? ((Item)storeContext).getFullDisplayName() : storeContext.getDisplayName()});
                }
            }
            return null;
        }
    }
}

