// CHECKSTYLE:OFF

package com.cloudbees.plugins.credentials;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Credentials
     * 
     */
    public static String UserCredentialsProvider_DisplayName() {
        return holder.format("UserCredentialsProvider_DisplayName");
    }

    /**
     * Credentials
     * 
     */
    public static Localizable _UserCredentialsProvider_DisplayName() {
        return new Localizable(holder, "UserCredentialsProvider_DisplayName");
    }

    /**
     * The create permission is necessary to add credentials to a credentials provider.
     * 
     */
    public static String CredentialsProvider_CreatePermissionDescription() {
        return holder.format("CredentialsProvider.CreatePermissionDescription");
    }

    /**
     * The create permission is necessary to add credentials to a credentials provider.
     * 
     */
    public static Localizable _CredentialsProvider_CreatePermissionDescription() {
        return new Localizable(holder, "CredentialsProvider.CreatePermissionDescription");
    }

    /**
     * The view permission is necessary to view the credentials stored in a credentials provider.
     * 
     */
    public static String CredentialsProvider_ViewPermissionDescription() {
        return holder.format("CredentialsProvider.ViewPermissionDescription");
    }

    /**
     * The view permission is necessary to view the credentials stored in a credentials provider.
     * 
     */
    public static Localizable _CredentialsProvider_ViewPermissionDescription() {
        return new Localizable(holder, "CredentialsProvider.ViewPermissionDescription");
    }

    /**
     * The manage domains permission is necessary to add/remove/configure the credential domains of a credentials provider (where the credentials provider supports multiple credential domains).
     * 
     */
    public static String CredentialsProvider_ManageDomainsPermissionDescription() {
        return holder.format("CredentialsProvider.ManageDomainsPermissionDescription");
    }

    /**
     * The manage domains permission is necessary to add/remove/configure the credential domains of a credentials provider (where the credentials provider supports multiple credential domains).
     * 
     */
    public static Localizable _CredentialsProvider_ManageDomainsPermissionDescription() {
        return new Localizable(holder, "CredentialsProvider.ManageDomainsPermissionDescription");
    }

    /**
     * Where an immediate action against a job requires that a credential be selected by the user triggering the action, this permission allows the user to select a credential from those credentials available within the scope of the job. Immediate actions could include: building with parameters, tagging a build, deploying artifacts, etc.
     * 
     */
    public static String CredentialsProvider_UseItemPermissionDescription() {
        return holder.format("CredentialsProvider.UseItemPermissionDescription");
    }

    /**
     * Where an immediate action against a job requires that a credential be selected by the user triggering the action, this permission allows the user to select a credential from those credentials available within the scope of the job. Immediate actions could include: building with parameters, tagging a build, deploying artifacts, etc.
     * 
     */
    public static Localizable _CredentialsProvider_UseItemPermissionDescription() {
        return new Localizable(holder, "CredentialsProvider.UseItemPermissionDescription");
    }

    /**
     * Global (Jenkins, nodes, items, all child items, etc)
     * 
     */
    public static String CredentialsScope_GlobalDisplayName() {
        return holder.format("CredentialsScope.GlobalDisplayName");
    }

    /**
     * Global (Jenkins, nodes, items, all child items, etc)
     * 
     */
    public static Localizable _CredentialsScope_GlobalDisplayName() {
        return new Localizable(holder, "CredentialsScope.GlobalDisplayName");
    }

    /**
     * Credentials that should be available irrespective of domain specification to requirements matching.
     * 
     */
    public static String CredentialsStoreAction_GlobalDomainDescription() {
        return holder.format("CredentialsStoreAction.GlobalDomainDescription");
    }

    /**
     * Credentials that should be available irrespective of domain specification to requirements matching.
     * 
     */
    public static Localizable _CredentialsStoreAction_GlobalDomainDescription() {
        return new Localizable(holder, "CredentialsStoreAction.GlobalDomainDescription");
    }

    /**
     * Credentials Parameter
     * 
     */
    public static String CredentialsParameterDefinition_DisplayName() {
        return holder.format("CredentialsParameterDefinition.DisplayName");
    }

    /**
     * Credentials Parameter
     * 
     */
    public static Localizable _CredentialsParameterDefinition_DisplayName() {
        return new Localizable(holder, "CredentialsParameterDefinition.DisplayName");
    }

    /**
     * User
     * 
     */
    public static String CredentialsScope_UserDisplayName() {
        return holder.format("CredentialsScope.UserDisplayName");
    }

    /**
     * User
     * 
     */
    public static Localizable _CredentialsScope_UserDisplayName() {
        return new Localizable(holder, "CredentialsScope.UserDisplayName");
    }

    /**
     * Not available to current user
     * 
     */
    public static String CredentialsParameterValue_NotAvailableToCurrentUser() {
        return holder.format("CredentialsParameterValue.NotAvailableToCurrentUser");
    }

    /**
     * Not available to current user
     * 
     */
    public static Localizable _CredentialsParameterValue_NotAvailableToCurrentUser() {
        return new Localizable(holder, "CredentialsParameterValue.NotAvailableToCurrentUser");
    }

    /**
     * System (Jenkins and nodes only)
     * 
     */
    public static String CredentialsScope_SystemDisplayName() {
        return holder.format("CredentialsScope.SystemDisplayName");
    }

    /**
     * System (Jenkins and nodes only)
     * 
     */
    public static Localizable _CredentialsScope_SystemDisplayName() {
        return new Localizable(holder, "CredentialsScope.SystemDisplayName");
    }

    /**
     * Credentials
     * 
     */
    public static String CredentialsProvider_PermissionGroupTitle() {
        return holder.format("CredentialsProvider.PermissionGroupTitle");
    }

    /**
     * Credentials
     * 
     */
    public static Localizable _CredentialsProvider_PermissionGroupTitle() {
        return new Localizable(holder, "CredentialsProvider.PermissionGroupTitle");
    }

    /**
     * The delete permission is necessary to remove credentials stored in a credentials provider.
     * 
     */
    public static String CredentialsProvider_DeletePermissionDescription() {
        return holder.format("CredentialsProvider.DeletePermissionDescription");
    }

    /**
     * The delete permission is necessary to remove credentials stored in a credentials provider.
     * 
     */
    public static Localizable _CredentialsProvider_DeletePermissionDescription() {
        return new Localizable(holder, "CredentialsProvider.DeletePermissionDescription");
    }

    /**
     * A domain with that name already exists
     * 
     */
    public static String CredentialsStoreAction_DuplicateDomainNameMessage() {
        return holder.format("CredentialsStoreAction.DuplicateDomainNameMessage");
    }

    /**
     * A domain with that name already exists
     * 
     */
    public static Localizable _CredentialsStoreAction_DuplicateDomainNameMessage() {
        return new Localizable(holder, "CredentialsStoreAction.DuplicateDomainNameMessage");
    }

    /**
     * You must provide a name for the domain
     * 
     */
    public static String CredentialsStoreAction_EmptyDomainNameMessage() {
        return holder.format("CredentialsStoreAction.EmptyDomainNameMessage");
    }

    /**
     * You must provide a name for the domain
     * 
     */
    public static Localizable _CredentialsStoreAction_EmptyDomainNameMessage() {
        return new Localizable(holder, "CredentialsStoreAction.EmptyDomainNameMessage");
    }

    /**
     * Credentials
     * 
     */
    public static String CredentialsStoreAction_DisplayName() {
        return holder.format("CredentialsStoreAction.DisplayName");
    }

    /**
     * Credentials
     * 
     */
    public static Localizable _CredentialsStoreAction_DisplayName() {
        return new Localizable(holder, "CredentialsStoreAction.DisplayName");
    }

    /**
     * Where an immediate action against a job requires that a credential be selected by the user triggering the action, this permission allows the user to select a credential from their private credential store. Immediate actions could include: building with parameters, tagging a build, deploying artifacts, etc.
     * 
     */
    public static String CredentialsProvider_UseOwnPermissionDescription() {
        return holder.format("CredentialsProvider.UseOwnPermissionDescription");
    }

    /**
     * Where an immediate action against a job requires that a credential be selected by the user triggering the action, this permission allows the user to select a credential from their private credential store. Immediate actions could include: building with parameters, tagging a build, deploying artifacts, etc.
     * 
     */
    public static Localizable _CredentialsProvider_UseOwnPermissionDescription() {
        return new Localizable(holder, "CredentialsProvider.UseOwnPermissionDescription");
    }

    /**
     * User: {0}
     * 
     */
    public static String CredentialsStoreAction_UserDisplayName(Object arg1) {
        return holder.format("CredentialsStoreAction.UserDisplayName", arg1);
    }

    /**
     * User: {0}
     * 
     */
    public static Localizable _CredentialsStoreAction_UserDisplayName(Object arg1) {
        return new Localizable(holder, "CredentialsStoreAction.UserDisplayName", arg1);
    }

    /**
     * The update permission is necessary to modify credentials in a credentials provider.
     * 
     */
    public static String CredentialsProvider_UpdatePermissionDescription() {
        return holder.format("CredentialsProvider.UpdatePermissionDescription");
    }

    /**
     * The update permission is necessary to modify credentials in a credentials provider.
     * 
     */
    public static Localizable _CredentialsProvider_UpdatePermissionDescription() {
        return new Localizable(holder, "CredentialsProvider.UpdatePermissionDescription");
    }

    /**
     * Global credentials (unrestricted)
     * 
     */
    public static String CredentialsStoreAction_GlobalDomainDisplayName() {
        return holder.format("CredentialsStoreAction.GlobalDomainDisplayName");
    }

    /**
     * Global credentials (unrestricted)
     * 
     */
    public static Localizable _CredentialsStoreAction_GlobalDomainDisplayName() {
        return new Localizable(holder, "CredentialsStoreAction.GlobalDomainDisplayName");
    }

    /**
     * Manage Credentials
     * 
     */
    public static String SystemCredentialsProvider_DisplayName() {
        return holder.format("SystemCredentialsProvider.DisplayName");
    }

    /**
     * Manage Credentials
     * 
     */
    public static Localizable _SystemCredentialsProvider_DisplayName() {
        return new Localizable(holder, "SystemCredentialsProvider.DisplayName");
    }

    /**
     * Create/delete/modify the credentials that can be used by Jenkins and by jobs running in Jenkins to connect to 3rd party services.
     * 
     */
    public static String SystemCredentialsProvider_Description() {
        return holder.format("SystemCredentialsProvider.Description");
    }

    /**
     * Create/delete/modify the credentials that can be used by Jenkins and by jobs running in Jenkins to connect to 3rd party services.
     * 
     */
    public static Localizable _SystemCredentialsProvider_Description() {
        return new Localizable(holder, "SystemCredentialsProvider.Description");
    }

    /**
     * Credentials Selection Helper
     * 
     */
    public static String CredentialsSelectHelper_DisplayName() {
        return holder.format("CredentialsSelectHelper.DisplayName");
    }

    /**
     * Credentials Selection Helper
     * 
     */
    public static Localizable _CredentialsSelectHelper_DisplayName() {
        return new Localizable(holder, "CredentialsSelectHelper.DisplayName");
    }

}
