/*
 * Decompiled with CFR 0.152.
 */
package hudson.markup;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import hudson.markup.HtmlPolicyBuilder2;
import java.io.IOException;
import java.util.regex.Pattern;
import org.owasp.html.Handler;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;
import org.owasp.html.PolicyFactory;

public class MyspacePolicy {
    public static final PolicyFactory POLICY_DEFINITION;
    private static final Pattern ONSITE_URL;
    private static final Pattern OFFSITE_URL;
    private static final Predicate<String> ONSITE_OR_OFFSITE_URL;

    public static void main(String[] args) throws IOException {
        String html = "<a href='http://www.google.com/'>Google</a><img src='http://www.yahoo.com'>";
        HtmlStreamRenderer renderer = HtmlStreamRenderer.create((Appendable)System.out, (Handler)new Handler<IOException>(){

            public void handle(IOException ex) {
                Throwables.propagate((Throwable)ex);
            }
        }, (Handler)new Handler<String>(){

            public void handle(String x) {
                throw new AssertionError((Object)x);
            }
        });
        HtmlSanitizer.sanitize((String)html, (HtmlSanitizer.Policy)POLICY_DEFINITION.apply((HtmlStreamEventReceiver)renderer));
    }

    static {
        ONSITE_URL = Pattern.compile("(?:[\\p{L}\\p{N}\\\\\\.\\#@\\$%\\+&;\\-_~,\\?=/!]+|\\#(\\w)+)");
        OFFSITE_URL = Pattern.compile("\\s*(?:(?:ht|f)tps?://|mailto:)[\\p{L}\\p{N}][\\p{L}\\p{N}\\p{Zs}\\.\\#@\\$%\\+&;:\\-_~,\\?=/!\\(\\)]*\\s*");
        ONSITE_OR_OFFSITE_URL = new Predicate<String>(){

            public boolean apply(String s) {
                return ONSITE_URL.matcher(s).matches() || OFFSITE_URL.matcher(s).matches();
            }
        };
        POLICY_DEFINITION = new HtmlPolicyBuilder2(){
            {
                this.allowAttributes(new String[]{"id", "class", "lang", "title", "alt", "style", "media", "href", "name", "shape", "border", "cellpadding", "cellspacing", "colspan", "rowspan", "background", "bgcolor", "abbr", "headers", "charoff", "char", "aixs", "nowrap", "width", "height", "align", "valign", "scope", "tabindex", "disabled", "readonly", "accesskey", "size", "autocomplete", "rows", "cols"}).globally();
                this.disallowElements(new String[]{"script", "noscript", "frameset", "frame"});
                this.tag("label", "for");
                this.tag("form", "action", ONSITE_URL, "method");
                this.tag("button", "value", "type");
                this.tag("input", "maxlength", "checked", "src", ONSITE_OR_OFFSITE_URL, "usemap", ONSITE_URL, "type", "value");
                this.tag("select", "multiple");
                this.tag("option", "value", "label", "selected");
                this.tag("textarea", new Object[0]);
                this.tag("h1,h2,h3,h4,h5,h6,p,i,b,u,strong,em,small,big,pre,code,cite,samp,sub,sup,strike,center,blockquote", new Object[0]);
                this.tag("hr,br,col", new Object[0]);
                this.tag("font", "color", "face", "size");
                this.tag("a", "nohref", "rel");
                this.tag("style", "type");
                this.tag("span,div", new Object[0]);
                this.tag("img", "src", ONSITE_OR_OFFSITE_URL, "hspace", "vspace");
                this.tag("ul,ol,li,dd,dl,dt,thead,tbody,tfoot", new Object[0]);
                this.tag("table", "noresize");
                this.tag("td,th,tr", new Object[0]);
                this.tag("colgroup", "span");
                this.tag("col", "span");
                this.tag("fieldset,legend", new Object[0]);
                this.allowStandardUrlProtocols();
            }
        }.toFactory();
    }
}

