/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.cli.auth.ssh;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.CliTransportAuthenticator;
import hudson.cli.Connection;
import hudson.model.User;
import hudson.remoting.Channel;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.main.modules.cli.auth.ssh.UserPropertyImpl;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;

@Extension
public class SshCliAuthenticator
extends CliTransportAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(SshCliAuthenticator.class.getName());

    public boolean supportsProtocol(String protocol) {
        return protocol.equals("ssh");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(String protocol, Channel channel, Connection c) {
        try {
            User u;
            byte[] sharedSecret = c.diffieHellman(true).generateSecret();
            InstanceIdentity ii = InstanceIdentity.get();
            c.proveIdentity(sharedSecret, new KeyPair(ii.getPublic(), ii.getPrivate()));
            do {
                PublicKey clientIdentity;
                if ((u = UserPropertyImpl.findUser(clientIdentity = c.verifyIdentity(sharedSecret))) != null) {
                    channel.setProperty((Object)CLICommand.TRANSPORT_AUTHENTICATION, (Object)u.impersonate());
                }
                c.writeBoolean(u != null);
            } while (u == null);
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.WARNING, "CLI authentication failure", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "CLI authentication failure", e);
        }
        finally {
            try {
                c.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to terminate the CLI authentication connection", e);
            }
        }
    }
}

