/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven3.launcher;

import org.apache.maven.Maven;
import org.apache.maven.cli.MavenExecutionRequestBuilder;
import org.apache.maven.cli.MavenLoggerManager;
import org.apache.maven.cli.PrintStreamLogger;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.jvnet.hudson.maven3.listeners.HudsonMavenExecutionResult;

public class Maven3Launcher {
    private static HudsonMavenExecutionResult hudsonMavenExecutionResult;
    private static ExecutionListener mavenExecutionListener;

    public static ExecutionListener getMavenExecutionListener() {
        return mavenExecutionListener;
    }

    public static void setMavenExecutionListener(ExecutionListener listener) {
        mavenExecutionListener = listener;
    }

    public static HudsonMavenExecutionResult getMavenExecutionResult() {
        return hudsonMavenExecutionResult;
    }

    public static void setMavenExecutionResult(HudsonMavenExecutionResult result) {
        hudsonMavenExecutionResult = result;
    }

    public static int main(String[] args) throws Exception {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            ClassRealm containerRealm = (ClassRealm)Thread.currentThread().getContextClassLoader();
            ContainerConfiguration cc = new DefaultContainerConfiguration().setName("maven").setRealm(containerRealm);
            DefaultPlexusContainer container = new DefaultPlexusContainer(cc);
            MavenLoggerManager mavenLoggerManager = new MavenLoggerManager((Logger)new PrintStreamLogger(System.out));
            container.setLoggerManager((LoggerManager)mavenLoggerManager);
            Maven maven = (Maven)container.lookup("org.apache.maven.Maven", "default");
            MavenExecutionRequest request = Maven3Launcher.getMavenExecutionRequest(args, container);
            MavenExecutionResult result = maven.execute(request);
            hudsonMavenExecutionResult = new HudsonMavenExecutionResult(result);
            int n = 0;
            return n;
        }
        catch (ComponentLookupException e) {
            throw new Exception(e.getMessage(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    private static MavenExecutionRequest getMavenExecutionRequest(String[] args, DefaultPlexusContainer container) throws Exception {
        MavenExecutionRequestBuilder mavenExecutionRequestBuilder = (MavenExecutionRequestBuilder)container.lookup(MavenExecutionRequestBuilder.class);
        MavenExecutionRequest request = mavenExecutionRequestBuilder.getMavenExecutionRequest(args, System.out);
        if (mavenExecutionListener != null) {
            request.setExecutionListener(mavenExecutionListener);
        }
        return request;
    }
}

