/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.util;

import hudson.tasks._maven.Maven3MojoNote;
import java.io.IOException;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEventLogger
extends org.apache.maven.cli.event.ExecutionEventLogger {
    private final Logger logger;

    public ExecutionEventLogger() {
        this.logger = LoggerFactory.getLogger(ExecutionEventLogger.class);
    }

    public ExecutionEventLogger(Logger logger) {
        super(logger);
        this.logger = logger;
    }

    public void mojoStarted(ExecutionEvent event) {
        if (this.logger.isInfoEnabled()) {
            Maven3MojoNote note = new Maven3MojoNote();
            StringBuilder buffer = new StringBuilder(128);
            try {
                buffer.append(note.encode());
            }
            catch (IOException e) {
                throw new RuntimeException("Could not encode note?", e);
            }
            buffer.append("--- ");
            this.append(buffer, event.getMojoExecution());
            this.append(buffer, event.getProject());
            buffer.append(" ---");
            this.logger.info("");
            this.logger.info(buffer.toString());
        }
    }

    private void append(StringBuilder buffer, MojoExecution me) {
        buffer.append(me.getArtifactId()).append(':').append(me.getVersion());
        buffer.append(':').append(me.getGoal());
        if (me.getExecutionId() != null) {
            buffer.append(" (").append(me.getExecutionId()).append(')');
        }
    }

    private void append(StringBuilder buffer, MavenProject project) {
        buffer.append(" @ ").append(project.getArtifactId());
    }
}

