/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.maven.MavenUtil;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.transfer.TransferListener;

public class MavenEmbedderRequest {
    private TaskListener listener;
    private File mavenHome;
    private String profiles;
    private Properties systemProperties;
    private String privateRepository;
    private File alternateSettings;
    private TransferListener transferListener;
    private ClassLoader classLoader = MavenEmbedderRequest.getDefaultMavenClassLoader();
    private boolean processPlugins;
    private boolean resolveDependencies;
    private int validationLevel = 20;
    private WorkspaceReader workspaceReader;
    private File globalSettings;
    private boolean updateSnapshots;

    public MavenEmbedderRequest(TaskListener listener, File mavenHome, String profiles, Properties systemProperties, String privateRepository, File alternateSettings) {
        this.listener = listener;
        this.mavenHome = mavenHome;
        this.profiles = profiles;
        this.systemProperties = systemProperties;
        this.privateRepository = privateRepository;
        this.alternateSettings = alternateSettings;
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public MavenEmbedderRequest setListener(TaskListener listener) {
        this.listener = listener;
        return this;
    }

    public File getMavenHome() {
        return this.mavenHome;
    }

    public MavenEmbedderRequest setMavenHome(File mavenHome) {
        this.mavenHome = mavenHome;
        return this;
    }

    public String getProfiles() {
        return this.profiles;
    }

    public MavenEmbedderRequest setProfiles(String profiles) {
        this.profiles = profiles;
        return this;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public MavenEmbedderRequest setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
        return this;
    }

    public String getPrivateRepository() {
        return this.privateRepository;
    }

    public MavenEmbedderRequest setPrivateRepository(String privateRepository) {
        this.privateRepository = privateRepository;
        return this;
    }

    public File getAlternateSettings() {
        return this.alternateSettings;
    }

    public MavenEmbedderRequest setAlternateSettings(File alternateSettings) {
        this.alternateSettings = alternateSettings;
        return this;
    }

    public TransferListener getTransferListener() {
        return this.transferListener;
    }

    public MavenEmbedderRequest setTransferListener(TransferListener transferListener) {
        this.transferListener = transferListener;
        return this;
    }

    public static ClassLoader getDefaultMavenClassLoader() {
        return new MaskingClassLoader(MavenUtil.class.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public MavenEmbedderRequest setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public boolean isProcessPlugins() {
        return this.processPlugins;
    }

    public MavenEmbedderRequest setProcessPlugins(boolean processPlugins) {
        this.processPlugins = processPlugins;
        return this;
    }

    public boolean isResolveDependencies() {
        return this.resolveDependencies;
    }

    public MavenEmbedderRequest setResolveDependencies(boolean resolveDependencies) {
        this.resolveDependencies = resolveDependencies;
        return this;
    }

    public int getValidationLevel() {
        return this.validationLevel;
    }

    public MavenEmbedderRequest setValidationLevel(int validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    public WorkspaceReader getWorkspaceReader() {
        return this.workspaceReader;
    }

    public void setWorkspaceReader(WorkspaceReader workspaceReader) {
        this.workspaceReader = workspaceReader;
    }

    public File getGlobalSettings() {
        return this.globalSettings;
    }

    public MavenEmbedderRequest setGlobalSettings(File globalSettings) {
        this.globalSettings = globalSettings;
        return this;
    }

    public MavenEmbedderRequest setUpdateSnapshots(boolean updateSnapshots) {
        this.updateSnapshots = updateSnapshots;
        return this;
    }

    public boolean isUpdateSnapshots() {
        return this.updateSnapshots;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MaskingClassLoader
    extends ClassLoader {
        public MaskingClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final Enumeration<URL> e = super.getResources(name);
            return new Enumeration<URL>(){
                URL next;

                @Override
                public boolean hasMoreElements() {
                    this.fetch();
                    return this.next != null;
                }

                @Override
                public URL nextElement() {
                    this.fetch();
                    URL r = this.next;
                    this.next = null;
                    return r;
                }

                private void fetch() {
                    while (this.next == null && e.hasMoreElements()) {
                        this.next = (URL)e.nextElement();
                        if (!this.shouldBeIgnored(this.next)) continue;
                        this.next = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private boolean shouldBeIgnored(URL url) {
                    BufferedReader r;
                    block8: {
                        boolean bl;
                        block7: {
                            String s = url.toExternalForm();
                            if (s.contains("maven-plugin-tools-api")) {
                                return true;
                            }
                            if (!s.endsWith("components.xml")) return false;
                            r = null;
                            try {
                                try {
                                    r = new BufferedReader(new InputStreamReader(url.openStream()));
                                    for (int i = 0; i < 2; ++i) {
                                        String l = r.readLine();
                                        if (l == null || !l.contains("MAVEN-INTERCEPTION-TO-BE-MASKED")) continue;
                                        bl = true;
                                        Object var8_8 = null;
                                        break block7;
                                    }
                                    break block8;
                                }
                                catch (IOException _) {
                                    Object var8_10 = null;
                                    IOUtils.closeQuietly(r);
                                    return false;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_11 = null;
                                IOUtils.closeQuietly(r);
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((Reader)r);
                        return bl;
                    }
                    Object var8_9 = null;
                    IOUtils.closeQuietly((Reader)r);
                    return false;
                }
            };
        }
    }
}

