/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.model.TaskListener;
import java.io.PrintStream;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;

final class TransferListenerImpl
implements TransferListener {
    private final PrintStream out;
    private long transferedSize;
    public static final String HEADER = "[:TRANSFER:]";

    public TransferListenerImpl(TaskListener listener) {
        this.out = listener.getLogger();
    }

    public void transferInitiated(TransferEvent e) {
        String url = e.getWagon().getRepository().getUrl();
        if (e.getRequestType() == 6) {
            this.out.println("Uploading to " + url);
        } else {
            this.out.println("Downloading " + url);
        }
    }

    public void transferStarted(TransferEvent e) {
        this.transferedSize = 0L;
        long total = e.getResource().getContentLength();
        this.out.println("[:TRANSFER:] start " + total);
    }

    public void transferProgress(TransferEvent e, byte[] buffer, int length) {
        this.transferedSize += (long)length;
        this.out.println("[:TRANSFER:] progress " + this.transferedSize);
    }

    public void transferCompleted(TransferEvent e) {
        this.out.println("[:TRANSFER:] completed");
    }

    public void transferError(TransferEvent e) {
        this.out.println("[:TRANSFER:] error");
        e.getException().printStackTrace(this.out);
    }

    public void debug(String message) {
    }
}

