/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.maven.reporters.MavenArtifact;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.maven.reporters.Messages;
import hudson.model.BuildListener;
import hudson.util.InvocationInterceptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class MavenArtifactArchiver
extends MavenReporter {
    private transient List<File> assemblies;
    private static final long serialVersionUID = 1L;

    public boolean preBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) throws InterruptedException, IOException {
        this.assemblies = null;
        return true;
    }

    public boolean preExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener) throws InterruptedException, IOException {
        if (mojo.is("org.apache.maven.plugins", "maven-assembly-plugin", "assembly")) {
            if (this.assemblies == null) {
                this.assemblies = new ArrayList<File>();
            }
            try {
                mojo.intercept("assemblyArchiver", new InvocationInterceptor(){

                    public Object invoke(Object proxy, Method method, Object[] args, InvocationHandler delegate) throws Throwable {
                        File f;
                        Object ret = delegate.invoke(proxy, method, args);
                        if (method.getName().equals("createArchive") && method.getReturnType() == File.class && !(f = (File)ret).isDirectory()) {
                            MavenArtifactArchiver.this.assemblies.add(f);
                        }
                        return ret;
                    }
                });
            }
            catch (NoSuchFieldException e) {
                listener.getLogger().println("[JENKINS] Failed to monitor the execution of the assembly plugin: " + e.getMessage());
            }
        }
        return true;
    }

    public boolean postBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) throws InterruptedException, IOException {
        HashSet<File> mavenArtifacts = new HashSet<File>();
        if (pom.getFile() != null) {
            final MavenArtifact pomArtifact = new MavenArtifact(pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), null, "pom", pom.getFile().getName(), Util.getDigestOf((InputStream)new FileInputStream(pom.getFile())));
            final String repositoryUrl = pom.getDistributionManagementArtifactRepository() == null ? null : Util.fixEmptyAndTrim((String)pom.getDistributionManagementArtifactRepository().getUrl());
            final String repositoryId = pom.getDistributionManagementArtifactRepository() == null ? null : Util.fixEmptyAndTrim((String)pom.getDistributionManagementArtifactRepository().getId());
            mavenArtifacts.add(pom.getFile());
            pomArtifact.archive(build, pom.getFile(), listener);
            final MavenArtifact mainArtifact = MavenArtifact.create(pom.getArtifact());
            if (mainArtifact != null) {
                File f = pom.getArtifact().getFile();
                mavenArtifacts.add(f);
                mainArtifact.archive(build, f, listener);
            }
            final ArrayList<MavenArtifact> attachedArtifacts = new ArrayList<MavenArtifact>();
            for (Artifact a : pom.getAttachedArtifacts()) {
                MavenArtifact ma = MavenArtifact.create(a);
                if (ma == null) continue;
                mavenArtifacts.add(a.getFile());
                ma.archive(build, a.getFile(), listener);
                attachedArtifacts.add(ma);
            }
            build.executeAsync(new MavenBuildProxy.BuildCallable<Void, IOException>(){
                private static final long serialVersionUID = -7955474564875700905L;

                @Override
                public Void call(MavenBuild build) throws IOException, InterruptedException {
                    List old = build.getActions(MavenArtifactRecord.class);
                    if (!old.isEmpty()) {
                        build.getActions().removeAll(old);
                    }
                    MavenArtifactRecord mar = new MavenArtifactRecord(build, pomArtifact, mainArtifact, attachedArtifacts, repositoryUrl, repositoryId);
                    build.addAction(mar);
                    mar.recordFingerprints();
                    return null;
                }
            });
        }
        if (build.isArchivingDisabled()) {
            listener.getLogger().println("[JENKINS] Archiving disabled");
        } else if (this.assemblies != null) {
            for (File assembly : this.assemblies) {
                if (mavenArtifacts.contains(assembly)) continue;
                FilePath target = build.getArtifactsDir().child(assembly.getName());
                listener.getLogger().println("[JENKINS] Archiving " + assembly + " to " + target);
                new FilePath(assembly).copyTo(target);
            }
        }
        return true;
    }

    @Extension
    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        public String getDisplayName() {
            return Messages.MavenArtifactArchiver_DisplayName();
        }

        public MavenReporter newAutoInstance(MavenModule module) {
            return new MavenArtifactArchiver();
        }
    }
}

