/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.maven.ModuleDependency;
import hudson.maven.ModuleName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PomInfo
implements Serializable {
    public static final String PACKAGING_TYPE_PLUGIN = "maven-plugin";
    public final ModuleName name;
    public final String displayName;
    public final String relativePath;
    public final String version;
    public final Set<ModuleDependency> dependencies = new HashSet<ModuleDependency>();
    public final List<ModuleName> children = new ArrayList<ModuleName>();
    public final String defaultGoal;
    public final PomInfo parent;
    private final String groupId;
    private final String artifactId;
    public final Notifier mailNotifier;
    public final String packaging;
    private static final long serialVersionUID = 1L;

    public PomInfo(MavenProject project, PomInfo parent, String relPath) {
        this.name = new ModuleName(project);
        this.version = project.getVersion();
        this.displayName = project.getName();
        this.defaultGoal = project.getDefaultGoal();
        this.relativePath = relPath;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this.name);
        }
        for (Dependency dep : project.getDependencies()) {
            this.dependencies.add(new ModuleDependency(dep));
        }
        MavenProject parentProject = project.getParent();
        if (parentProject != null) {
            this.dependencies.add(new ModuleDependency(parentProject));
        }
        if (parent != null) {
            this.dependencies.add(parent.asDependency());
        }
        this.addPluginsAsDependencies(project.getBuildPlugins(), this.dependencies);
        this.addReportPluginsAsDependencies(project.getReportPlugins(), this.dependencies);
        List extensions = project.getBuildExtensions();
        if (extensions != null) {
            for (Extension ext : extensions) {
                this.dependencies.add(new ModuleDependency(ext));
            }
        }
        this.dependencies.remove(this.asDependency());
        CiManagement ciMgmt = project.getCiManagement();
        if (ciMgmt != null && (ciMgmt.getSystem() == null || ciMgmt.getSystem().equals("hudson"))) {
            Notifier mailNotifier = null;
            for (Notifier n : ciMgmt.getNotifiers()) {
                if (!n.getType().equals("mail")) continue;
                mailNotifier = n;
                break;
            }
            this.mailNotifier = mailNotifier;
        } else {
            this.mailNotifier = null;
        }
        this.groupId = project.getGroupId();
        this.artifactId = project.getArtifactId();
        this.packaging = project.getPackaging();
    }

    private ModuleDependency asDependency() {
        return new ModuleDependency(this.name, this.version, PACKAGING_TYPE_PLUGIN.equals(this.packaging));
    }

    private void addPluginsAsDependencies(List<Plugin> plugins, Set<ModuleDependency> dependencies) {
        if (plugins == null) {
            return;
        }
        for (Plugin p : plugins) {
            dependencies.add(new ModuleDependency(p));
        }
    }

    private void addReportPluginsAsDependencies(List<ReportPlugin> plugins, Set<ModuleDependency> dependencies) {
        if (plugins == null) {
            return;
        }
        for (ReportPlugin p : plugins) {
            dependencies.add(new ModuleDependency(p));
        }
    }

    void cutCycle() {
        ModuleDependency dep = this.asDependency();
        PomInfo p = this.parent;
        while (p != null) {
            if (p.dependencies.contains(dep)) {
                p.dependencies.remove(dep);
            }
            p = p.parent;
        }
    }

    public int getNestLevel() {
        int i = 0;
        PomInfo p = this.parent;
        while (p != null) {
            ++i;
            p = p.parent;
        }
        return i;
    }

    public int hashCode() {
        int hash = 23 + this.groupId == null ? 1 : this.groupId.hashCode();
        return hash += this.artifactId == null ? 1 : this.artifactId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PomInfo)) {
            return false;
        }
        PomInfo pomInfo = (PomInfo)obj;
        return StringUtils.equals((String)pomInfo.groupId, (String)this.groupId) && StringUtils.equals((String)pomInfo.artifactId, (String)this.artifactId);
    }

    public boolean isSimilar(ModuleName moduleName, Set<ModuleDependency> dependencies) {
        return StringUtils.equals((String)this.groupId, (String)moduleName.groupId) && StringUtils.equals((String)this.artifactId, (String)moduleName.artifactId) && ((Object)this.dependencies).equals(dependencies);
    }

    public String toString() {
        return "PomInfo:[" + this.groupId + ':' + this.artifactId + ']' + "[relativePath:" + this.relativePath + ']';
    }
}

