/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import java.io.Serializable;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleName
implements Comparable<ModuleName>,
Serializable {
    public final String groupId;
    public final String artifactId;
    private static final long serialVersionUID = 1L;

    public ModuleName(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public ModuleName(ExecutionEvent event) {
        this(event.getProject());
    }

    public ModuleName(MavenProject project) {
        this(project.getGroupId(), project.getArtifactId());
    }

    public ModuleName(Plugin plugin) {
        this(plugin.getGroupId(), plugin.getArtifactId());
    }

    public ModuleName(ReportPlugin plugin) {
        this(plugin.getGroupId(), plugin.getArtifactId());
    }

    public ModuleName(Extension ext) {
        this(ext.getGroupId(), ext.getArtifactId());
    }

    public ModuleName(Dependency dep) {
        this(dep.getGroupId(), dep.getArtifactId());
    }

    public String toString() {
        return this.groupId + ':' + this.artifactId;
    }

    public String toFileSystemName() {
        return this.groupId + '$' + this.artifactId;
    }

    public static ModuleName fromFileSystemName(String n) {
        int idx = n.indexOf(36);
        if (idx < 0) {
            throw new IllegalArgumentException(n);
        }
        return new ModuleName(n.substring(0, idx), n.substring(idx + 1));
    }

    public static ModuleName fromString(String n) {
        int idx = Math.max(n.indexOf(58), n.indexOf(36));
        if (idx < 0) {
            throw new IllegalArgumentException(n);
        }
        return new ModuleName(n.substring(0, idx), n.substring(idx + 1));
    }

    public static boolean isValid(String n) {
        return Math.max(n.indexOf(58), n.indexOf(36)) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleName that = (ModuleName)o;
        return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        return result;
    }

    @Override
    public int compareTo(ModuleName that) {
        int r = this.groupId.compareTo(that.groupId);
        if (r != 0) {
            return r;
        }
        return this.artifactId.compareTo(that.artifactId);
    }
}

