/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.AbstractMavenProcessFactory;
import hudson.maven.MavenModuleSet;
import hudson.maven.Messages;
import hudson.maven.ProcessCache;
import hudson.maven.agent.AbortException;
import hudson.maven.agent.Main;
import hudson.maven.agent.Maven21Interceptor;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Which;
import hudson.tasks.Maven;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

final class MavenProcessFactory
extends AbstractMavenProcessFactory
implements ProcessCache.Factory {
    private static final FilenameFilter CLASSWORLDS_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.contains("classworlds") && name.endsWith(".jar");
        }
    };
    public static boolean debug = false;
    public static boolean profile = Boolean.getBoolean("hudson.maven.profile");
    public static int socketTimeOut = Integer.parseInt(System.getProperty("hudson.maven.socketTimeOut", Integer.toString(30000)));

    MavenProcessFactory(MavenModuleSet mms, Launcher launcher, EnvVars envVars, String mavenOpts, FilePath workDir) {
        super(mms, launcher, envVars, mavenOpts, workDir);
    }

    protected String getMavenAgentClassPath(Maven.MavenInstallation mvn, boolean isMaster, FilePath slaveRoot, BuildListener listener) throws IOException, InterruptedException {
        String classWorldsJar = (String)this.getLauncher().getChannel().call((Callable)new GetClassWorldsJar(mvn.getHome(), (TaskListener)listener));
        String classPath = (isMaster ? Which.jarFile(Main.class).getAbsolutePath() : slaveRoot.child("maven-agent.jar").getRemote()) + (this.getLauncher().isUnix() ? ":" : ";") + (isMaster ? classWorldsJar : slaveRoot.child("classworlds.jar").getRemote());
        return classPath;
    }

    protected String getMainClassName() {
        return Main.class.getName();
    }

    protected String getMavenInterceptorClassPath(Maven.MavenInstallation mvn, boolean isMaster, FilePath slaveRoot) throws IOException, InterruptedException {
        return isMaster ? Which.jarFile(AbortException.class).getAbsolutePath() : slaveRoot.child("maven-interceptor.jar").getRemote();
    }

    protected String getMavenInterceptorOverride(Maven.MavenInstallation mvn, boolean isMaster, FilePath slaveRoot) throws IOException, InterruptedException {
        if (mvn.isMaven2_1(this.getLauncher())) {
            return isMaster ? Which.jarFile(Maven21Interceptor.class).getAbsolutePath() : slaveRoot.child("maven2.1-interceptor.jar").getRemote();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetClassWorldsJar
    implements Callable<String, IOException> {
        private static final long serialVersionUID = 5812919424079344101L;
        private final String mvnHome;
        private final TaskListener listener;

        private GetClassWorldsJar(String mvnHome, TaskListener listener) {
            this.mvnHome = mvnHome;
            this.listener = listener;
        }

        public String call() throws IOException {
            File home = new File(this.mvnHome);
            File bootDir = new File(home, "core/boot");
            File[] classworlds = bootDir.listFiles(CLASSWORLDS_FILTER);
            if (!(classworlds != null && classworlds.length != 0 || (classworlds = (bootDir = new File(home, "boot")).listFiles(CLASSWORLDS_FILTER)) != null && classworlds.length != 0)) {
                this.listener.error(Messages.MavenProcessFactory_ClassWorldsNotFound(home));
                throw new Run.RunnerAbortedException();
            }
            return classworlds[0].getAbsolutePath();
        }
    }
}

