/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.EnvVars;
import hudson.maven.Messages;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.util.RemotingDiagnostics;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenProbeAction
implements Action {
    private final transient Channel channel;
    public final AbstractProject<?, ?> owner;

    MavenProbeAction(AbstractProject<?, ?> owner, Channel channel) {
        this.channel = channel;
        this.owner = owner;
    }

    public String getIconFileName() {
        if (this.channel == null) {
            return null;
        }
        return "computer.gif";
    }

    public String getDisplayName() {
        return Messages.MavenProbeAction_DisplayName();
    }

    public String getUrlName() {
        if (this.channel == null) {
            return null;
        }
        return "probe";
    }

    public Map<Object, Object> getSystemProperties() throws IOException, InterruptedException {
        return RemotingDiagnostics.getSystemProperties((VirtualChannel)this.channel);
    }

    public Map<String, String> getEnvVars() throws IOException, InterruptedException {
        return EnvVars.getRemote((VirtualChannel)this.channel);
    }

    public Map<String, String> getThreadDump() throws IOException, InterruptedException {
        return RemotingDiagnostics.getThreadDump((VirtualChannel)this.channel);
    }

    public void doScript(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.owner.checkPermission(Jenkins.RUN_SCRIPTS);
        String text = req.getParameter("script");
        if (text != null) {
            try {
                req.setAttribute("output", (Object)RemotingDiagnostics.executeGroovy((String)text, (VirtualChannel)this.channel));
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
        }
        req.getView((Object)this, "_script.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public RemotingDiagnostics.HeapDump getHeapDump() throws IOException {
        return new RemotingDiagnostics.HeapDump(this.owner, (VirtualChannel)this.channel);
    }
}

