/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Extension;
import hudson.FilePath;
import hudson.maven.agent.AbortException;
import hudson.maven.agent.Main;
import hudson.maven.agent.Maven21Interceptor;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.Which;
import hudson.slaves.ComputerListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.jvnet.hudson.maven3.agent.Maven3Main;
import org.jvnet.hudson.maven3.launcher.Maven3Launcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class MavenComputerListener
extends ComputerListener {
    public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        this.copyJar(logger, root, Main.class, "maven-agent");
        this.copyJar(logger, root, Maven3Main.class, "maven3-agent");
        this.copyJar(logger, root, Maven3Launcher.class, "maven3-interceptor");
        this.copyJar(logger, root, AbortException.class, "maven-interceptor");
        this.copyJar(logger, root, Maven21Interceptor.class, "maven2.1-interceptor");
        this.copyJar(logger, root, ClassWorld.class, "plexus-classworld");
        root.child("classworlds.jar").copyFrom(((Object)((Object)this)).getClass().getClassLoader().getResource("classworlds.jar"));
        logger.println("Copied classworlds.jar");
    }

    private void copyJar(PrintStream log, FilePath dst, Class<?> representative, String seedName) throws IOException, InterruptedException {
        File jar = Which.jarFile(representative);
        if (jar.isDirectory()) {
            Zip zip = new Zip();
            zip.setBasedir(jar);
            File t = File.createTempFile(seedName, "jar");
            t.delete();
            zip.setDestFile(t);
            zip.setProject(new Project());
            zip.execute();
            jar = t;
        }
        new FilePath(jar).copyTo(dst.child(seedName + ".jar"));
        log.println("Copied " + seedName + ".jar");
    }
}

