/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;

public class FullDuplexHttpStream {
    private final URL target;
    private final OutputStream output;
    private final InputStream input;
    static final int BLOCK_SIZE = 1024;
    static final Logger LOGGER = Logger.getLogger(FullDuplexHttpStream.class.getName());

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public FullDuplexHttpStream(URL target) throws IOException {
        this.target = target;
        String authorization = null;
        if (target.getUserInfo() != null) {
            new Base64();
            authorization = new String(Base64.encodeBase64((byte[])target.getUserInfo().getBytes()));
        }
        CrumbData crumbData = new CrumbData();
        UUID uuid = UUID.randomUUID();
        HttpURLConnection con = (HttpURLConnection)target.openConnection();
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.addRequestProperty("Session", uuid.toString());
        con.addRequestProperty("Side", "download");
        if (authorization != null) {
            con.addRequestProperty("Authorization", "Basic " + authorization);
        }
        if (crumbData.isValid) {
            con.addRequestProperty(crumbData.crumbName, crumbData.crumb);
        }
        con.getOutputStream().close();
        this.input = con.getInputStream();
        if (con.getHeaderField("Hudson-Duplex") == null) {
            throw new IOException(target + " doesn't look like Hudson");
        }
        con = (HttpURLConnection)target.openConnection();
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setChunkedStreamingMode(0);
        con.setRequestProperty("Content-type", "application/octet-stream");
        con.addRequestProperty("Session", uuid.toString());
        con.addRequestProperty("Side", "upload");
        if (authorization != null) {
            con.addRequestProperty("Authorization", "Basic " + authorization);
        }
        if (crumbData.isValid) {
            con.addRequestProperty(crumbData.crumbName, crumbData.crumb);
        }
        this.output = con.getOutputStream();
    }

    private final class CrumbData {
        String crumbName = "";
        String crumb = "";
        boolean isValid = false;

        private CrumbData() {
            this.getData();
        }

        private void getData() {
            try {
                String base = this.createCrumbUrlBase();
                this.crumbName = this.readData(base + "?xpath=/*/crumbRequestField/text()");
                this.crumb = this.readData(base + "?xpath=/*/crumb/text()");
                this.isValid = true;
                LOGGER.fine("Crumb data: " + this.crumbName + "=" + this.crumb);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to get crumb data", e);
            }
        }

        private String createCrumbUrlBase() {
            String url = FullDuplexHttpStream.this.target.toExternalForm();
            return url.substring(0, url.lastIndexOf("/cli")) + "/crumbIssuer/api/xml/";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readData(String dest) throws IOException {
            HttpURLConnection con = (HttpURLConnection)new URL(dest).openConnection();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String string = reader.readLine();
                return string;
            }
            finally {
                con.disconnect();
            }
        }
    }
}

