/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResponseImpl
implements WebResponse {
    private static final long serialVersionUID = 2842434739251092348L;
    private static final Log LOG = LogFactory.getLog(WebResponseImpl.class);
    private long loadTime_;
    private WebResponseData responseData_;
    private WebRequestSettings requestSettings_;

    public WebResponseImpl(WebResponseData responseData, URL url, HttpMethod requestMethod, long loadTime) {
        this(responseData, new WebRequestSettings(url, requestMethod), loadTime);
    }

    @Deprecated
    public WebResponseImpl(WebResponseData responseData, String charset, WebRequestSettings requestSettings, long loadTime) {
        this(responseData, requestSettings, loadTime);
    }

    public WebResponseImpl(WebResponseData responseData, WebRequestSettings requestSettings, long loadTime) {
        this.responseData_ = responseData;
        this.requestSettings_ = requestSettings;
        this.loadTime_ = loadTime;
    }

    @Override
    public WebRequestSettings getRequestSettings() {
        return this.requestSettings_;
    }

    @Override
    @Deprecated
    public HttpMethod getRequestMethod() {
        return this.getRequestSettings().getHttpMethod();
    }

    @Override
    @Deprecated
    public URL getRequestUrl() {
        return this.getRequestSettings().getUrl();
    }

    @Override
    public URL getUrl() {
        return this.getRequestUrl();
    }

    @Override
    public List<NameValuePair> getResponseHeaders() {
        return this.responseData_.getResponseHeaders();
    }

    @Override
    public String getResponseHeaderValue(String headerName) {
        for (NameValuePair pair : this.responseData_.getResponseHeaders()) {
            if (!pair.getName().equalsIgnoreCase(headerName)) continue;
            return pair.getValue();
        }
        return null;
    }

    @Override
    public int getStatusCode() {
        return this.responseData_.getStatusCode();
    }

    @Override
    public String getStatusMessage() {
        return this.responseData_.getStatusMessage();
    }

    @Override
    public String getContentType() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        if (contentTypeHeader == null) {
            return "";
        }
        int index = contentTypeHeader.indexOf(59);
        if (index == -1) {
            return contentTypeHeader;
        }
        return contentTypeHeader.substring(0, index);
    }

    @Override
    @Deprecated
    public String getContentCharSet() {
        return this.getContentCharset();
    }

    @Override
    public String getContentCharsetOrNull() {
        try {
            return EncodingSniffer.sniffEncoding(this.getResponseHeaders(), this.getContentAsStream());
        }
        catch (IOException e) {
            LOG.warn((Object)"Error trying to sniff encoding.", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getContentCharset() {
        String charset = this.getContentCharsetOrNull();
        if (charset == null) {
            charset = this.getRequestSettings().getCharset();
        }
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        return charset;
    }

    @Override
    public String getContentAsString() {
        return this.getContentAsString(this.getContentCharset());
    }

    @Override
    public String getContentAsString(String encoding) {
        byte[] body = this.responseData_.getBody();
        if (body != null) {
            try {
                return new String(body, encoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Attempted to use unsupported encoding '" + encoding + "'; using default system encoding."));
                return new String(body);
            }
        }
        return null;
    }

    @Override
    public InputStream getContentAsStream() throws IOException {
        return this.responseData_.getInputStream();
    }

    @Override
    public byte[] getContentAsBytes() {
        return this.responseData_.getBody();
    }

    @Override
    public long getLoadTime() {
        return this.loadTime_;
    }
}

