/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ProxyConfig
implements Serializable {
    private static final long serialVersionUID = -9164636437071690421L;
    private String proxyHost_;
    private int proxyPort_;
    private final Map<String, Pattern> proxyBypassHosts_;
    private String proxyAutoConfigUrl_;
    private String proxyAutoConfigContent_;

    public ProxyConfig() {
        this(null, 0);
    }

    public ProxyConfig(String proxyHost, int proxyPort) {
        this.proxyHost_ = proxyHost;
        this.proxyPort_ = proxyPort;
        this.proxyBypassHosts_ = new HashMap<String, Pattern>();
    }

    public String getProxyHost() {
        return this.proxyHost_;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost_ = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort_;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort_ = proxyPort;
    }

    public void addHostsToProxyBypass(String pattern) {
        this.proxyBypassHosts_.put(pattern, Pattern.compile(pattern));
    }

    public void removeHostsFromProxyBypass(String pattern) {
        this.proxyBypassHosts_.remove(pattern);
    }

    protected boolean shouldBypassProxy(String hostname) {
        boolean bypass = false;
        for (Pattern p : this.proxyBypassHosts_.values()) {
            if (!p.matcher(hostname).find()) continue;
            bypass = true;
            break;
        }
        return bypass;
    }

    public String getProxyAutoConfigUrl() {
        return this.proxyAutoConfigUrl_;
    }

    public void setProxyAutoConfigUrl(String proxyAutoConfigUrl) {
        this.proxyAutoConfigUrl_ = proxyAutoConfigUrl;
        this.setProxyAutoConfigContent(null);
    }

    protected String getProxyAutoConfigContent() {
        return this.proxyAutoConfigContent_;
    }

    protected void setProxyAutoConfigContent(String proxyAutoConfigContent) {
        this.proxyAutoConfigContent_ = proxyAutoConfigContent;
    }
}

