/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.bytecode;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.jenkinsci.bytecode.ClassRewritingContext;
import org.jenkinsci.bytecode.TransformationSpec;
import org.kohsuke.asm5.ClassReader;
import org.kohsuke.asm5.ClassVisitor;
import org.kohsuke.asm5.ClassWriter;
import org.kohsuke.asm5.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer {
    private volatile TransformationSpec spec = new TransformationSpec();

    public void loadRules(ClassLoader cl) throws IOException {
        this.loadRules(Collections.singleton(cl));
    }

    public synchronized void loadRules(Collection<? extends ClassLoader> loaders) throws IOException {
        TransformationSpec spec = new TransformationSpec(this.spec);
        for (ClassLoader classLoader : loaders) {
            spec.loadRule(classLoader);
        }
        this.spec = spec;
    }

    public byte[] transform(String className, byte[] image) {
        if (!this.spec.mayNeedTransformation(image)) {
            return image;
        }
        ClassReader cr = new ClassReader(image);
        final ClassWriter cw = new ClassWriter(1);
        final boolean[] modified = new boolean[1];
        cr.accept(new ClassVisitor(327680, (ClassVisitor)cw){
            private ClassRewritingContext context;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(Math.max(version, 49), access, name, signature, superName, interfaces);
                this.context = new ClassRewritingContext(name);
            }

            public MethodVisitor visitMethod(int access, String methodName, String methodDescriptor, String methodSignature, String[] exceptions) {
                final MethodVisitor base = super.visitMethod(access, methodName, methodDescriptor, methodSignature, exceptions);
                return new MethodVisitor(327680, base){

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        modified[0] = modified[0] | ((Transformer)Transformer.this).spec.methods.rewrite(context, opcode, owner, name, desc, itf, base);
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        modified[0] = modified[0] | ((Transformer)Transformer.this).spec.fields.rewrite(context, opcode, owner, name, desc, false, base);
                    }
                };
            }

            public void visitEnd() {
                this.context.generateCheckerMethods((ClassVisitor)cw);
                super.visitEnd();
            }
        }, 4);
        if (!modified[0]) {
            return image;
        }
        return cw.toByteArray();
    }
}

