/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.flows.workflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.jeasy.flows.work.Work;
import org.jeasy.flows.work.WorkContext;
import org.jeasy.flows.work.WorkReport;
import org.jeasy.flows.workflow.AbstractWorkFlow;
import org.jeasy.flows.workflow.ParallelFlowExecutor;
import org.jeasy.flows.workflow.ParallelFlowReport;

public class ParallelFlow
extends AbstractWorkFlow {
    private List<Work> workUnits = new ArrayList<Work>();
    private ParallelFlowExecutor workExecutor;

    ParallelFlow(String name, List<Work> workUnits, ParallelFlowExecutor parallelFlowExecutor) {
        super(name);
        this.workUnits.addAll(workUnits);
        this.workExecutor = parallelFlowExecutor;
    }

    @Override
    public ParallelFlowReport execute(WorkContext workContext) {
        ParallelFlowReport workFlowReport = new ParallelFlowReport();
        List<WorkReport> workReports = this.workExecutor.executeInParallel(this.workUnits, workContext);
        workFlowReport.addAll(workReports);
        return workFlowReport;
    }

    public static class Builder {
        private Builder() {
        }

        public static NameStep aNewParallelFlow() {
            return new BuildSteps();
        }

        private static class BuildSteps
        implements NameStep,
        ExecuteStep,
        WithStep,
        BuildStep {
            private String name = UUID.randomUUID().toString();
            private List<Work> works = new ArrayList<Work>();
            private ExecutorService executorService;

            @Override
            public ExecuteStep named(String name) {
                this.name = name;
                return this;
            }

            @Override
            public WithStep execute(Work ... workUnits) {
                this.works.addAll(Arrays.asList(workUnits));
                return this;
            }

            @Override
            public BuildStep with(ExecutorService executorService) {
                this.executorService = executorService;
                return this;
            }

            @Override
            public ParallelFlow build() {
                return new ParallelFlow(this.name, this.works, new ParallelFlowExecutor(this.executorService));
            }
        }

        public static interface BuildStep {
            public ParallelFlow build();
        }

        public static interface WithStep {
            public BuildStep with(ExecutorService var1);
        }

        public static interface ExecuteStep {
            public WithStep execute(Work ... var1);
        }

        public static interface NameStep
        extends ExecuteStep {
            public ExecuteStep named(String var1);
        }
    }
}

