/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.core.util.IoUtils;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorMerger;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorIO;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentDescriptorManagerUtil {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentDescriptorManagerUtil.class);

    public static DeploymentDescriptor getDeploymentDescriptor(DeploymentDescriptorManager manager, KieContainer kieContainer, MergeMode mode, DeploymentDescriptor ... presets) {
        InputStream is;
        KieProject kieProject;
        ArrayList<DeploymentDescriptor> descriptorHierarchy = new ArrayList<DeploymentDescriptor>();
        if (presets != null) {
            descriptorHierarchy.addAll(Arrays.stream(presets).filter(e -> e != null).collect(Collectors.toList()));
        }
        if ((kieProject = ((KieContainerImpl)kieContainer).getKieProject()) instanceof KieModuleKieProject) {
            InternalKieModule module = ((KieModuleKieProject)kieProject).getInternalKieModule();
            DeploymentDescriptorManagerUtil.collectDeploymentDescriptors(module, descriptorHierarchy);
        } else if (kieProject instanceof ClasspathKieProject && (is = ((ClasspathKieProject)kieProject).getClassLoader().getResourceAsStream("META-INF/kie-deployment-descriptor.xml")) != null) {
            try {
                descriptorHierarchy.add(DeploymentDescriptorManagerUtil.getDescriptorFromContent(IoUtils.readBytesFromInputStream((InputStream)is)));
            }
            catch (IOException e2) {
                logger.warn("Could not read deployment descriptor on classpath", (Throwable)e2);
            }
        }
        descriptorHierarchy.add(manager.getDefaultDescriptor());
        return new DeploymentDescriptorMerger().merge(descriptorHierarchy, mode);
    }

    public static List<DeploymentDescriptor> getDeploymentDescriptorHierarchy(DeploymentDescriptorManager manager, KieContainer kieContainer) {
        InputStream is;
        ArrayList<DeploymentDescriptor> descriptorHierarchy = new ArrayList<DeploymentDescriptor>();
        KieProject kieProject = ((KieContainerImpl)kieContainer).getKieProject();
        if (kieProject instanceof KieModuleKieProject) {
            InternalKieModule module = ((KieModuleKieProject)kieProject).getInternalKieModule();
            DeploymentDescriptorManagerUtil.collectDeploymentDescriptors(module, descriptorHierarchy);
        } else if (kieProject instanceof ClasspathKieProject && (is = ((ClasspathKieProject)kieProject).getClassLoader().getResourceAsStream("META-INF/kie-deployment-descriptor.xml")) != null) {
            try {
                descriptorHierarchy.add(DeploymentDescriptorManagerUtil.getDescriptorFromContent(IoUtils.readBytesFromInputStream((InputStream)is)));
            }
            catch (IOException e) {
                logger.warn("Could not read deployment descriptor on classpath", (Throwable)e);
            }
        }
        descriptorHierarchy.add(manager.getDefaultDescriptor());
        return descriptorHierarchy;
    }

    protected static void collectDeploymentDescriptors(InternalKieModule kmodule, List<DeploymentDescriptor> descriptorHierarchy) {
        DeploymentDescriptor descriptor = DeploymentDescriptorManagerUtil.getDescriptorFromKModule(kmodule);
        if (descriptor != null) {
            descriptorHierarchy.add(descriptor);
        }
        if (kmodule.getKieDependencies() != null) {
            Collection depModules = kmodule.getKieDependencies().values();
            for (InternalKieModule depModule : depModules) {
                DeploymentDescriptorManagerUtil.collectDeploymentDescriptors(depModule, descriptorHierarchy);
            }
        }
    }

    protected static DeploymentDescriptor getDescriptorFromKModule(InternalKieModule kmodule) {
        DeploymentDescriptor desc = null;
        if (kmodule.isAvailable("META-INF/kie-deployment-descriptor.xml")) {
            byte[] content = kmodule.getBytes("META-INF/kie-deployment-descriptor.xml");
            desc = DeploymentDescriptorManagerUtil.getDescriptorFromContent(content);
        }
        return desc;
    }

    protected static DeploymentDescriptor getDescriptorFromContent(byte[] content) {
        DeploymentDescriptor deploymentDescriptor;
        ByteArrayInputStream input = new ByteArrayInputStream(content);
        try {
            deploymentDescriptor = DeploymentDescriptorIO.fromXml((InputStream)input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.warn("Error while reading stream of kie-deployment-descriptor.xml");
                return null;
            }
        }
        input.close();
        return deploymentDescriptor;
    }
}

