/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.validation;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jbpm.process.core.validation.ProcessValidator;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;

public class ProcessValidatorRegistry {
    private static ProcessValidatorRegistry instance;
    private Map<String, ProcessValidator> defaultValidators = new ConcurrentHashMap<String, ProcessValidator>();
    private Set<ProcessValidator> additionalValidators = new CopyOnWriteArraySet<ProcessValidator>();

    private ProcessValidatorRegistry() {
        this.defaultValidators.put("RuleFlow", RuleFlowProcessValidator.getInstance());
    }

    public static ProcessValidatorRegistry getInstance() {
        if (instance == null) {
            instance = new ProcessValidatorRegistry();
        }
        return instance;
    }

    public void registerAdditonalValidator(ProcessValidator validator) {
        this.additionalValidators.add(validator);
    }

    public ProcessValidator getValidator(Process process, Resource resource) {
        if (!this.additionalValidators.isEmpty()) {
            for (ProcessValidator validator : this.additionalValidators) {
                boolean accepted = validator.accept(process, resource);
                if (!accepted) continue;
                return validator;
            }
        }
        return this.defaultValidators.get(process.getType());
    }
}

