/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.jbpm.process.core.transformation.JavaScriptingDataTransformer;
import org.jbpm.process.core.transformation.MVELDataTransformer;
import org.kie.api.runtime.process.DataTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransformerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DataTransformerRegistry.class);
    private static final DataTransformerRegistry INSTANCE = new DataTransformerRegistry();
    private Map<String, DataTransformer> registry = new ConcurrentHashMap<String, DataTransformer>();

    protected DataTransformerRegistry() {
        this.registry.put("http://www.mvel.org/2.0", new MVELDataTransformer());
        ScriptEngineManager manager = new ScriptEngineManager();
        List<ScriptEngineFactory> factories = manager.getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            JavaScriptingDataTransformer transformer = new JavaScriptingDataTransformer(factory);
            for (String name : factory.getNames()) {
                String key = "http://www.java.com/" + name;
                this.registry.put(key, transformer);
                logger.debug("Registered scripting language {} with instance {}", (Object)key, (Object)transformer);
            }
        }
    }

    public static DataTransformerRegistry get() {
        return INSTANCE;
    }

    public synchronized void register(String language, DataTransformer transformer) {
        this.registry.put(language, transformer);
        logger.debug("Manual registration of scripting language {} with instance {}", (Object)language, (Object)transformer);
    }

    public DataTransformer find(String languge) {
        return this.registry.get(languge);
    }
}

