/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.io.Serializable;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.jbpm.workflow.instance.node.EventNodeInstanceInterface;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;

public class EventNodeInstance
extends ExtendedNodeInstanceImpl
implements EventNodeInstanceInterface,
EventBasedNodeInstanceInterface {
    private static final long serialVersionUID = 510L;
    private EventListener listener = new ExternalEventListener();

    @Override
    public void signalEvent(String type, Object event) {
        String variableName = this.getEventNode().getVariableName();
        if (variableName != null) {
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", variableName);
            if (variableScopeInstance == null) {
                throw new IllegalArgumentException("Could not find variable for event node: " + variableName);
            }
            EventTransformer transformer = this.getEventNode().getEventTransformer();
            if (transformer != null) {
                event = transformer.transformEvent(event);
            }
            variableScopeInstance.setVariable(variableName, event);
        }
        this.triggerCompleted();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("An EventNode only accepts default incoming connections!");
        }
        this.addEventListeners();
    }

    public EventNode getEventNode() {
        return (EventNode)this.getNode();
    }

    public void triggerCompleted() {
        this.getProcessInstance().removeEventListener(this.getEventNode().getType(), this.listener, true);
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).setCurrentLevel(this.getLevel());
        this.triggerCompleted("DROOLS_DEFAULT", true);
    }

    @Override
    public void cancel() {
        this.getProcessInstance().removeEventListener(this.getEventNode().getType(), this.listener, true);
        super.cancel();
    }

    @Override
    public void addEventListeners() {
        this.getProcessInstance().addEventListener(this.getEventNode().getType(), this.listener, true);
    }

    @Override
    public void removeEventListeners() {
    }

    private class ExternalEventListener
    implements EventListener,
    Serializable {
        private static final long serialVersionUID = 5L;

        private ExternalEventListener() {
        }

        public String[] getEventTypes() {
            return null;
        }

        public void signalEvent(String type, Object event) {
        }
    }
}

