/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.ArrayList;
import java.util.Set;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.impl.ParameterDefinitionImpl;
import org.drools.core.process.core.impl.WorkImpl;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.WorkItemNode;

public class WorkItemNodeFactory
extends NodeFactory {
    public WorkItemNodeFactory(RuleFlowNodeContainerFactory nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, id);
    }

    @Override
    protected Node createNode() {
        return new WorkItemNode();
    }

    protected WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    public WorkItemNodeFactory name(String name) {
        this.getNode().setName(name);
        return this;
    }

    public WorkItemNodeFactory waitForCompletion(boolean waitForCompletion) {
        this.getWorkItemNode().setWaitForCompletion(waitForCompletion);
        return this;
    }

    public WorkItemNodeFactory inMapping(String parameterName, String variableName) {
        this.getWorkItemNode().addInMapping(parameterName, variableName);
        return this;
    }

    public WorkItemNodeFactory outMapping(String parameterName, String variableName) {
        this.getWorkItemNode().addOutMapping(parameterName, variableName);
        return this;
    }

    public WorkItemNodeFactory workName(String name) {
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getWorkItemNode().setWork(work);
        }
        work.setName(name);
        return this;
    }

    public WorkItemNodeFactory workParameter(String name, Object value) {
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getWorkItemNode().setWork(work);
        }
        work.setParameter(name, value);
        return this;
    }

    public WorkItemNodeFactory workParameterDefinition(String name, DataType dataType) {
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getWorkItemNode().setWork(work);
        }
        Set parameterDefinitions = work.getParameterDefinitions();
        parameterDefinitions.add(new ParameterDefinitionImpl(name, dataType));
        work.setParameterDefinitions(parameterDefinitions);
        return this;
    }

    public WorkItemNodeFactory onEntryAction(String dialect, String action) {
        if (this.getWorkItemNode().getActions(dialect) != null) {
            this.getWorkItemNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getWorkItemNode().setActions("onEntry", actions);
        }
        return this;
    }

    public WorkItemNodeFactory onExitAction(String dialect, String action) {
        if (this.getWorkItemNode().getActions(dialect) != null) {
            this.getWorkItemNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getWorkItemNode().setActions("onExit", actions);
        }
        return this;
    }

    public WorkItemNodeFactory timer(String delay, String period, String dialect, String action) {
        Timer timer = new Timer();
        timer.setDelay(delay);
        timer.setPeriod(period);
        this.getWorkItemNode().addTimer(timer, new DroolsConsequenceAction(dialect, action));
        return this;
    }
}

