/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.command;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.jbpm.process.instance.ProcessInstance;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ResumeProcessInstanceCommand
implements GenericCommand<Object> {
    private static final long serialVersionUID = 6L;
    @XmlAttribute
    private Long processInstanceId;

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Object execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        if (this.processInstanceId == null) {
            return null;
        }
        org.kie.api.runtime.process.ProcessInstance processInstance = ksession.getProcessInstance(this.processInstanceId.longValue());
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + this.processInstanceId);
        }
        if (processInstance.getState() != 4) {
            throw new IllegalArgumentException("Process instance with id " + this.processInstanceId + " in state " + processInstance.getState());
        }
        ((ProcessInstance)processInstance).setState(1);
        return null;
    }

    public String toString() {
        return "session.abortProcessInstance(" + this.processInstanceId + ");";
    }
}

