/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.plugins.tools;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jboss.ws.plugins.tools.AbstractToolsMojo;
import org.jboss.ws.plugins.tools.Util;
import org.jboss.ws.plugins.tools.WSContractConsumerParams;
import org.jboss.ws.plugins.tools.WSContractDelegate;

public abstract class AbstractWsConsumeMojo
extends AbstractToolsMojo {
    private List<String> wsdls;
    protected List<String> bindingFiles;
    private File catalog;
    protected Boolean additionalHeaders;
    protected File sourceDirectory;
    protected Boolean noCompile = true;
    protected String targetPackage;
    private String wsdlLocation;
    protected String encoding;
    private String target;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (this.wsdls == null) {
            this.getLog().info((CharSequence)"No wsdl URL / file specified, nothing to do.");
            return;
        }
        if (this.verbose.booleanValue()) {
            log.info((CharSequence)"Classpath:");
            for (String s : this.getClasspathElements()) {
                log.info((CharSequence)(" " + s));
            }
        }
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            URLClassLoader loader = this.getMavenClasspathAwareClassLoader();
            Thread.currentThread().setContextClassLoader(loader);
            WSContractConsumerParams params = new WSContractConsumerParams();
            params.setAdditionalCompilerClassPath(new LinkedList<String>(this.getClasspathElements()));
            params.setBindingFiles(this.bindingFiles);
            params.setCatalog(this.catalog);
            params.setAdditionalHeaders(this.additionalHeaders);
            params.setExtension(this.extension);
            params.setGenerateSource(this.generateSource);
            params.setLoader(loader);
            params.setNoCompile(this.noCompile);
            params.setOutputDirectory(this.getOutputDirectory());
            params.setSourceDirectory(this.sourceDirectory);
            params.setTarget(this.target);
            params.setTargetPackage(this.targetPackage);
            params.setWsdlLocation(this.wsdlLocation);
            params.setEncoding(this.encoding);
            params.setArgLine(this.argLine);
            if (this.fork.booleanValue() || Util.getJVMMajorVersion() > 8) {
                params.setFork(true);
                File manifestOnlyJar = this.createJar((List)this.getClasspathElements(), "");
                params.setManifestOnlyJar(manifestOnlyJar);
                if (this.verbose.booleanValue()) {
                    log.info((CharSequence)"Additional plugin classpath:");
                    for (File f : this.getRequiredPluginDependencyPaths()) {
                        log.info((CharSequence)(" " + f.getAbsolutePath()));
                    }
                }
            }
            WSContractDelegate delegate = new WSContractDelegate(this.getLog());
            for (String wsdl : this.wsdls) {
                try {
                    delegate.runConsumer(params, wsdl);
                }
                catch (MalformedURLException mue) {
                    log.error((CharSequence)("Skipping invalid wsdl reference: " + wsdl));
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error while running wsconsume", e);
                }
            }
            this.updateProjectSourceRoots();
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Error while running wsconsume", (Exception)ioe);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    public List<String> getWsdls() {
        return this.wsdls;
    }

    public List<String> getBindingFiles() {
        return this.bindingFiles;
    }

    public File getCatalog() {
        return this.catalog;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getTarget() {
        return this.target;
    }

    public Boolean isAdditionalHeaders() {
        return this.additionalHeaders;
    }
}

