/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.cache.LoadingCache;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.interceptor.Interceptor;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeContext;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.AnnotatedTypeLoader;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.BeanDeployerEnvironmentFactory;
import org.jboss.weld.bootstrap.FastAnnotatedTypeLoader;
import org.jboss.weld.bootstrap.FastProcessAnnotatedTypeResolver;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.enablement.GlobalEnablementBuilder;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.AnnotationApiAbstraction;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.collections.Multimaps;
import org.jboss.weld.util.reflection.Reflections;

public class BeanDeployer
extends AbstractBeanDeployer<BeanDeployerEnvironment> {
    private final ResourceLoader resourceLoader;
    private final SlimAnnotatedTypeStore annotatedTypeStore;
    private final GlobalEnablementBuilder globalEnablementBuilder;
    private final AnnotationApiAbstraction annotationApi;
    private final ClassFileServices classFileServices;

    public BeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services) {
        this(manager, ejbDescriptors, services, BeanDeployerEnvironmentFactory.newEnvironment(ejbDescriptors, manager));
    }

    public BeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services, BeanDeployerEnvironment environment) {
        super(manager, services, environment);
        this.resourceLoader = manager.getServices().get(ResourceLoader.class);
        this.annotatedTypeStore = manager.getServices().get(SlimAnnotatedTypeStore.class);
        this.globalEnablementBuilder = manager.getServices().get(GlobalEnablementBuilder.class);
        this.annotationApi = manager.getServices().get(AnnotationApiAbstraction.class);
        this.classFileServices = manager.getServices().get(ClassFileServices.class);
    }

    public BeanDeployer addClass(String className, AnnotatedTypeLoader loader) {
        SlimAnnotatedTypeContext ctx = loader.loadAnnotatedType(className, this.getManager().getId());
        if (ctx != null) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addAnnotatedType(ctx);
        }
        return this;
    }

    private void processPriority(AnnotatedType<?> type) {
        Integer value;
        Annotation priority = type.getAnnotation(this.annotationApi.PRIORITY_ANNOTATION_CLASS);
        if (priority != null && (value = this.annotationApi.getPriority(priority)) != null) {
            if (type.isAnnotationPresent(Interceptor.class)) {
                this.globalEnablementBuilder.addInterceptor(type.getJavaClass(), value);
            } else if (type.isAnnotationPresent(Decorator.class)) {
                this.globalEnablementBuilder.addDecorator(type.getJavaClass(), value);
            } else {
                this.globalEnablementBuilder.addAlternative(type.getJavaClass(), value);
            }
        }
    }

    public <T> BeanDeployer addSyntheticClass(AnnotatedType<T> source, Extension extension, String suffix) {
        if (suffix == null) {
            suffix = AnnotatedTypes.createTypeId(source);
        }
        ((BeanDeployerEnvironment)this.getEnvironment()).addSyntheticAnnotatedType(this.classTransformer.getUnbackedAnnotatedType(source, this.getManager().getId(), suffix), extension);
        return this;
    }

    public BeanDeployer addClasses(Iterable<String> classes) {
        AnnotatedTypeLoader loader = this.createAnnotatedTypeLoader();
        for (String className : classes) {
            this.addClass(className, loader);
        }
        return this;
    }

    protected AnnotatedTypeLoader createAnnotatedTypeLoader() {
        FastProcessAnnotatedTypeResolver resolver;
        if (this.classFileServices != null && (resolver = Container.instance(this.getManager()).deploymentManager().getServices().get(FastProcessAnnotatedTypeResolver.class)) != null) {
            return new FastAnnotatedTypeLoader(this.getManager(), this.classTransformer, this.classFileServices, this.containerLifecycleEvents, resolver);
        }
        return new AnnotatedTypeLoader(this.getManager(), this.classTransformer, this.containerLifecycleEvents);
    }

    public void processAnnotatedTypes() {
        HashSet classesToBeAdded = new HashSet();
        HashSet classesToBeRemoved = new HashSet();
        for (SlimAnnotatedTypeContext<?> annotatedTypeContext : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            SlimAnnotatedType<?> annotatedType = annotatedTypeContext.getAnnotatedType();
            ProcessAnnotatedTypeImpl<?> event = this.containerLifecycleEvents.fireProcessAnnotatedType(this.getManager(), annotatedTypeContext);
            if (event != null) {
                if (event.isVeto()) {
                    ((BeanDeployerEnvironment)this.getEnvironment()).vetoJavaClass(annotatedType.getJavaClass());
                    classesToBeRemoved.add(annotatedTypeContext);
                    continue;
                }
                boolean dirty = event.isDirty();
                if (dirty) {
                    classesToBeRemoved.add(annotatedTypeContext);
                    classesToBeAdded.add(SlimAnnotatedTypeContext.of(event.getResultingAnnotatedType(), this.classTransformer, annotatedTypeContext.getExtension()));
                }
                this.processPriority(event.getResultingAnnotatedType());
                continue;
            }
            this.processPriority(annotatedType);
        }
        ((BeanDeployerEnvironment)this.getEnvironment()).removeAnnotatedTypes(classesToBeRemoved);
        ((BeanDeployerEnvironment)this.getEnvironment()).addAnnotatedTypes(classesToBeAdded);
    }

    public void registerAnnotatedTypes() {
        for (SlimAnnotatedTypeContext<?> ctx : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            this.annotatedTypeStore.put(ctx.getAnnotatedType());
        }
    }

    public void createClassBeans() {
        LoadingCache<Class<?>, Set<SlimAnnotatedType<?>>> otherWeldClasses = Multimaps.newConcurrentSetMultimap();
        for (SlimAnnotatedTypeContext<?> ctx : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            this.createClassBean(ctx.getAnnotatedType(), otherWeldClasses);
        }
        for (InternalEjbDescriptor ejbDescriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()) {
            if (((BeanDeployerEnvironment)this.getEnvironment()).isVetoed(ejbDescriptor.getBeanClass()) || Beans.isVetoed(ejbDescriptor.getBeanClass()) || !ejbDescriptor.isSingleton() && !ejbDescriptor.isStateful() && !ejbDescriptor.isStateless()) continue;
            if (otherWeldClasses.getIfPresent(ejbDescriptor.getBeanClass()) != null) {
                for (SlimAnnotatedType<?> annotatedType : LoadingCacheUtils.getCacheValue(otherWeldClasses, ejbDescriptor.getBeanClass())) {
                    EnhancedAnnotatedType<?> weldClass = this.classTransformer.getEnhancedAnnotatedType(annotatedType);
                    this.createSessionBean(ejbDescriptor, (EnhancedAnnotatedType)Reflections.cast(weldClass));
                }
                continue;
            }
            this.createSessionBean(ejbDescriptor);
        }
    }

    protected void createClassBean(SlimAnnotatedType<?> annotatedType, LoadingCache<Class<?>, Set<SlimAnnotatedType<?>>> otherWeldClasses) {
        boolean managedBeanOrDecorator;
        boolean bl = managedBeanOrDecorator = !((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors().contains(annotatedType.getJavaClass()) && Beans.isTypeManagedBeanOrDecoratorOrInterceptor(annotatedType);
        if (managedBeanOrDecorator) {
            this.containerLifecycleEvents.preloadProcessInjectionTarget(annotatedType.getJavaClass());
            this.containerLifecycleEvents.preloadProcessBeanAttributes(annotatedType.getJavaClass());
            EnhancedAnnotatedType<?> weldClass = this.classTransformer.getEnhancedAnnotatedType(annotatedType);
            if (weldClass.isAnnotationPresent(Decorator.class)) {
                this.containerLifecycleEvents.preloadProcessBean(ProcessBean.class, annotatedType.getJavaClass());
                this.validateDecorator(weldClass);
                this.createDecorator(weldClass);
            } else if (weldClass.isAnnotationPresent(Interceptor.class)) {
                this.containerLifecycleEvents.preloadProcessBean(ProcessBean.class, annotatedType.getJavaClass());
                this.validateInterceptor(weldClass);
                this.createInterceptor(weldClass);
            } else if (!weldClass.isAbstract()) {
                this.containerLifecycleEvents.preloadProcessBean(ProcessManagedBean.class, annotatedType.getJavaClass());
                this.createManagedBean(weldClass);
            }
        } else {
            Class<? extends Annotation> scopeClass;
            if (Beans.isDecoratorDeclaringInAppropriateConstructor(annotatedType)) {
                BootstrapLogger.LOG.decoratorWithNonCdiConstructor(annotatedType.getJavaClass().getName());
            }
            if ((scopeClass = Beans.getBeanDefiningAnnotationScope(annotatedType)) != null && !Beans.hasSimpleCdiConstructor(annotatedType)) {
                BootstrapLogger.LOG.annotatedTypeNotRegisteredAsBeanDueToMissingAppropriateConstructor(annotatedType.getJavaClass().getName(), scopeClass.getSimpleName());
            }
            LoadingCacheUtils.getCacheValue(otherWeldClasses, annotatedType.getJavaClass()).add(annotatedType);
        }
    }

    public void processClassBeanAttributes() {
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
    }

    private void preInitializeBeans(Iterable<? extends AbstractBean<?, ?>> beans) {
        for (AbstractBean<?, ?> bean : beans) {
            bean.preInitialize();
        }
    }

    protected void processBeanAttributes(Iterable<? extends AbstractBean<?, ?>> beans) {
        if (!this.containerLifecycleEvents.isProcessBeanAttributesObserved()) {
            return;
        }
        if (!beans.iterator().hasNext()) {
            return;
        }
        HashSet vetoedBeans = new HashSet();
        HashSet previouslySpecializedBeans = new HashSet();
        for (AbstractBean<?, ?> abstractBean : beans) {
            boolean vetoed = this.fireProcessBeanAttributes(abstractBean);
            if (!vetoed) continue;
            vetoedBeans.add(abstractBean);
        }
        for (AbstractBean<Object, Object> abstractBean : vetoedBeans) {
            if (abstractBean.isSpecializing()) {
                previouslySpecializedBeans.addAll(this.specializationAndEnablementRegistry.resolveSpecializedBeans(abstractBean));
                this.specializationAndEnablementRegistry.vetoSpecializingBean(abstractBean);
            }
            ((BeanDeployerEnvironment)this.getEnvironment()).vetoBean(abstractBean);
        }
        this.processBeanAttributes(previouslySpecializedBeans);
    }

    protected void searchForNewBeanDeclarations(Iterable<? extends AbstractBean<?, ?>> beans) {
        for (AbstractBean<?, ?> bean : beans) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addNewBeansFromInjectionPoints(bean);
        }
    }

    public void createProducersAndObservers() {
        for (AbstractClassBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getClassBeans()) {
            this.createObserversProducersDisposers(bean);
        }
    }

    public void processProducerAttributes() {
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getProducerFields());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getProducerFields());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeans());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeans());
        this.searchForNewBeanDeclarations(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeans());
    }

    public void createNewBeans() {
        for (EnhancedAnnotatedType<?> enhancedAnnotatedType : ((BeanDeployerEnvironment)this.getEnvironment()).getNewManagedBeanClasses()) {
            this.createNewManagedBean(enhancedAnnotatedType);
        }
        for (Map.Entry entry : ((BeanDeployerEnvironment)this.getEnvironment()).getNewSessionBeanDescriptorsFromInjectionPoint().entrySet()) {
            InternalEjbDescriptor descriptor = (InternalEjbDescriptor)entry.getKey();
            this.createNewSessionBean(descriptor, BeanAttributesFactory.forSessionBean((EnhancedAnnotatedType)entry.getValue(), descriptor, this.getManager()), (EnhancedAnnotatedType)entry.getValue());
        }
    }

    public void deploy() {
        this.initializeBeans();
        this.fireBeanEvents();
        this.deployBeans();
        this.initializeObserverMethods();
        this.deployObserverMethods();
    }

    protected void validateInterceptor(EnhancedAnnotatedType<?> weldClass) {
        if (weldClass.isAnnotationPresent(Decorator.class)) {
            throw BootstrapLogger.LOG.beanIsBothInterceptorAndDecorator(weldClass.getName());
        }
    }

    protected void validateDecorator(EnhancedAnnotatedType<?> weldClass) {
        if (weldClass.isAnnotationPresent(Interceptor.class)) {
            throw BootstrapLogger.LOG.beanIsBothInterceptorAndDecorator(weldClass.getName());
        }
    }

    public void doAfterBeanDiscovery(List<? extends Bean<?>> beanList) {
        for (Bean<?> bean : beanList) {
            if (!(bean instanceof RIBean)) continue;
            ((RIBean)bean).initializeAfterBeanDiscovery();
        }
    }

    public void registerCdiInterceptorsForMessageDrivenBeans() {
        EjbServices ejbServices = this.getManager().getServices().get(EjbServices.class);
        for (InternalEjbDescriptor<?> descriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()) {
            InterceptionModel model;
            if (!descriptor.isMessageDriven()) continue;
            EnhancedAnnotatedType type = this.classTransformer.getEnhancedAnnotatedType(descriptor.getBeanClass(), this.getManager().getId());
            if (!this.getManager().getInterceptorModelRegistry().containsKey(type.slim())) {
                InterceptionModelInitializer.of(this.getManager(), type, null).init();
            }
            if ((model = (InterceptionModel)this.getManager().getInterceptorModelRegistry().get(type.slim())) == null) continue;
            ejbServices.registerInterceptors(descriptor.delegate(), new InterceptorBindingsAdapter(model));
        }
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void cleanup() {
        ((BeanDeployerEnvironment)this.getEnvironment()).cleanup();
    }
}

