/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;

public final class BeanArchives {
    public static final String BEAN_ARCHIVE_ID_BASE_DELIMITER = "_";

    private BeanArchives() {
    }

    public static <B extends BeanDeploymentArchive> Multimap<String, BeanDeploymentArchive> findBeanClassesDeployedInMultipleBeanArchives(Set<B> beanArchives) {
        HashMultimap problems;
        block7: {
            block6: {
                if (beanArchives.size() == 1) {
                    return ImmutableSetMultimap.of();
                }
                problems = HashMultimap.create();
                if (beanArchives.size() != 2) break block6;
                Iterator<B> iterator = beanArchives.iterator();
                BeanDeploymentArchive first = (BeanDeploymentArchive)iterator.next();
                BeanDeploymentArchive beanDeploymentArchive = (BeanDeploymentArchive)iterator.next();
                HashSet intersection = new HashSet(first.getBeanClasses());
                intersection.retainAll(beanDeploymentArchive.getBeanClasses());
                if (intersection.isEmpty()) break block7;
                ImmutableList bdas = ImmutableList.of((Object)first, (Object)beanDeploymentArchive);
                for (String beanClass : intersection) {
                    problems.putAll((Object)beanClass, (Iterable)bdas);
                }
                break block7;
            }
            if (beanArchives.size() > 2) {
                HashMultimap beanClassOccurrences = HashMultimap.create();
                for (BeanDeploymentArchive beanDeploymentArchive : beanArchives) {
                    for (String beanClass : beanDeploymentArchive.getBeanClasses()) {
                        beanClassOccurrences.put((Object)beanClass, (Object)beanDeploymentArchive);
                    }
                }
                for (Map.Entry entry : beanClassOccurrences.asMap().entrySet()) {
                    if (((Collection)entry.getValue()).size() <= 1) continue;
                    problems.putAll(entry.getKey(), (Iterable)entry.getValue());
                }
            }
        }
        return problems;
    }

    public static String extractBeanArchiveId(String beanArchiveRef, String base, String separator) {
        beanArchiveRef = beanArchiveRef.replace('\\', '/');
        StringBuilder id = new StringBuilder();
        id.append(base);
        id.append(BEAN_ARCHIVE_ID_BASE_DELIMITER);
        if (beanArchiveRef.contains(separator)) {
            id.append(beanArchiveRef.substring(beanArchiveRef.indexOf(separator), beanArchiveRef.length()));
        } else {
            id.append(beanArchiveRef);
        }
        return id.toString();
    }
}

