/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public final class Reflections {
    private Reflections() {
    }

    public static boolean containsAnnotation(Class<?> javaClass, Class<? extends Annotation> requiredAnnotation) {
        for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            if ((clazz == javaClass || requiredAnnotation.isAnnotationPresent(Inherited.class)) && Reflections.containsAnnotations(clazz.getAnnotations(), requiredAnnotation)) {
                return true;
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (!Reflections.containsAnnotations(field.getAnnotations(), requiredAnnotation)) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : clazz.getConstructors()) {
                if (Reflections.containsAnnotations(accessibleObject.getAnnotations(), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Constructor)accessibleObject).getParameterAnnotations()) {
                    if (!Reflections.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (Reflections.containsAnnotations(accessibleObject.getAnnotations(), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Method)accessibleObject).getParameterAnnotations()) {
                    if (!Reflections.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static <T> T newInstance(ResourceLoader loader, String className, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        try {
            Class clazz = (Class)Reflections.cast(loader.classForName(className));
            Constructor<T> constructor = Reflections.findConstructor(clazz, parameters);
            return constructor.newInstance(parameters);
        }
        catch (Exception e) {
            throw CommonLogger.LOG.unableToInstantiate(className, Arrays.toString(parameters), e);
        }
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static boolean isClassLoadable(String className, ResourceLoader resourceLoader) {
        return Reflections.loadClass(className, resourceLoader) != null;
    }

    public static <T> Class<T> loadClass(String className, ResourceLoader resourceLoader) {
        try {
            return (Class)Reflections.cast(resourceLoader.classForName(className));
        }
        catch (ResourceLoadingException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static boolean hasBeanDefiningMetaAnnotationSpecified(Annotation[] annotations, Class<? extends Annotation> metaAnnotationType) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(metaAnnotationType)) continue;
            return true;
        }
        return false;
    }

    private static <T> Constructor<T> findConstructor(Class<T> clazz, Object ... parameters) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            boolean match = true;
            for (int i = 0; i < parameters.length; ++i) {
                if (constructor.getParameterTypes()[i].isAssignableFrom(parameters[i].getClass())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return (Constructor)Reflections.cast(constructor);
        }
        throw CommonLogger.LOG.unableToFindConstructor(clazz, Arrays.toString(parameters));
    }

    private static boolean containsAnnotations(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation) {
        return Reflections.containsAnnotation(annotations, requiredAnnotation, true);
    }

    private static boolean containsAnnotation(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation, boolean checkMetaAnnotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (requiredAnnotation.equals(annotationType)) {
                return true;
            }
            if (!checkMetaAnnotations || !Reflections.containsAnnotation(annotationType.getAnnotations(), requiredAnnotation, false)) continue;
            return true;
        }
        return false;
    }
}

