/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.shrinkwrap.api.asset.Asset;

public class UrlAsset
implements Asset {
    private final URL url;

    public UrlAsset(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL must be specified");
        }
        try {
            this.url = new URL(url.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL is malformed " + e.getLocalizedMessage());
        }
    }

    @Override
    public InputStream openStream() {
        try {
            return new BufferedInputStream(this.url.openStream(), 8192);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not open stream for url " + this.url.toExternalForm(), e);
        }
    }

    public URL getSource() {
        return this.url;
    }

    public String toString() {
        return UrlAsset.class.getSimpleName() + " [url=" + this.url.toExternalForm() + "]";
    }
}

