/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.task;

import java.io.File;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import org.jboss.shrinkwrap.resolver.impl.maven.task.SecurityActions;
import org.jboss.shrinkwrap.resolver.impl.maven.util.FileUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadPomTask
implements MavenWorkingSessionTask<MavenWorkingSession> {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final File pomFile;
    private final String[] profiles;

    private LoadPomTask(File pomFile, String[] profiles) {
        this.pomFile = pomFile;
        this.profiles = profiles == null ? EMPTY_ARRAY : profiles;
    }

    public static LoadPomTask loadPomFromFile(File pomFile, String ... profiles) {
        Validate.notNull(pomFile, "POM file must be specified");
        return new LoadPomTask(pomFile, profiles);
    }

    public static LoadPomTask loadPomFromFile(String pathToPomFile, String ... profiles) throws IllegalArgumentException, InvalidConfigurationFileException {
        Validate.notNullOrEmpty(pathToPomFile, "Path to a POM file must be specified");
        Validate.readable(pathToPomFile, "Path to the pom.xml ('" + pathToPomFile + "')file must be defined and accessible");
        return new LoadPomTask(new File(pathToPomFile), profiles);
    }

    public static LoadPomTask loadPomFromClassLoaderResource(String pathToPomResource) throws IllegalArgumentException, InvalidConfigurationFileException {
        return LoadPomTask.loadPomFromClassLoaderResource(pathToPomResource, SecurityActions.getThreadContextClassLoader());
    }

    public static LoadPomTask loadPomFromClassLoaderResource(String pathToPomResource, ClassLoader cl) throws IllegalArgumentException, InvalidConfigurationFileException {
        return LoadPomTask.loadPomFromClassLoaderResource(pathToPomResource, cl, EMPTY_ARRAY);
    }

    public static LoadPomTask loadPomFromClassLoaderResource(String pathToPomResource, ClassLoader cl, String ... profiles) throws IllegalArgumentException, InvalidConfigurationFileException {
        Validate.notNullOrEmpty(pathToPomResource, "path to CL resource must be specified");
        Validate.notNull(cl, "ClassLoader must be specified");
        File file = FileUtil.INSTANCE.fileFromClassLoaderResource(pathToPomResource, cl);
        return new LoadPomTask(file, profiles);
    }

    @Override
    public MavenWorkingSession execute(MavenWorkingSession session) {
        Validate.notNull(this.pomFile, "Path to pom.xml file must not be null");
        Validate.readable(this.pomFile, "Path to the POM ('" + this.pomFile + "') file must be defined and accessible");
        return session.loadPomFromFile(this.pomFile, this.profiles);
    }
}

