/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.hibernate;

import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class PatternFilter
implements VirtualFileFilter,
ResourceFilter {
    private String pattern;
    private boolean exact = true;

    public PatternFilter(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Null pattern");
        }
        this.exact = !pattern.contains("/");
        this.pattern = !this.exact && pattern.startsWith("**/*") ? pattern.substring(4) : pattern;
    }

    protected boolean accepts(String name) {
        return this.exact ? name.equals(this.pattern) : name.endsWith(this.pattern);
    }

    public boolean accepts(VirtualFile file) {
        String name = this.exact ? file.getName() : file.getPathName();
        return this.accepts(name);
    }

    public boolean accepts(ResourceContext resource) {
        String name = this.exact ? PatternFilter.getName(resource) : resource.getResourceName();
        return this.accepts(name);
    }

    static String getName(ResourceContext resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource");
        }
        String name = resource.getResourceName();
        int p = name.lastIndexOf("/");
        return p >= 0 ? name.substring(p + 1) : name;
    }
}

