/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.annotations.plugins;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.scanning.annotations.plugins.AbstractElement;
import org.jboss.scanning.annotations.plugins.ClassElement;
import org.jboss.scanning.annotations.plugins.ClassSignaturePair;
import org.jboss.scanning.annotations.plugins.DefaultElement;
import org.jboss.scanning.annotations.plugins.MutableAnnotationRepository;
import org.jboss.scanning.annotations.plugins.ParametersElement;
import org.jboss.scanning.annotations.spi.Element;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.util.collection.CollectionsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAnnotationRepository
extends MutableAnnotationRepository
implements Externalizable,
ScanningHandle<DefaultAnnotationRepository> {
    private static final long serialVersionUID = 1L;
    private Map<String, Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>>> env;
    private transient Set<String> checkedClassNames = new HashSet<String>();
    private boolean keepAnnotations;
    private Map<String, Set<String>> classesImplementingInterfaceAnnotatedWith;

    public DefaultAnnotationRepository() {
    }

    public DefaultAnnotationRepository(ClassLoader classLoader) {
        super(classLoader);
        this.env = new HashMap<String, Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>>>();
        this.classesImplementingInterfaceAnnotatedWith = new HashMap<String, Set<String>>();
    }

    protected ClassLoader getClassLoader() {
        return super.getClassLoader();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.env);
        out.writeObject(this.classesImplementingInterfaceAnnotatedWith);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.env = (Map)in.readObject();
        this.classesImplementingInterfaceAnnotatedWith = (Map)in.readObject();
    }

    public void setKeepAnnotations(boolean keepAnnotations) {
        this.keepAnnotations = keepAnnotations;
    }

    void cleanup() {
        this.env.clear();
        this.classesImplementingInterfaceAnnotatedWith.clear();
        this.checkedClassNames.clear();
    }

    @Override
    public Set<String> classesImplementingInterfacesAnnotatedWith(String annotation) {
        Set<String> classes = this.classesImplementingInterfaceAnnotatedWith.get(annotation);
        if (classes == null) {
            return Collections.emptySet();
        }
        return classes;
    }

    @Override
    public void addClassImplementingInterfaceAnnotatedWith(String annotationName, String className) {
        Set<String> classes = this.classesImplementingInterfaceAnnotatedWith.get(annotationName);
        if (classes == null) {
            classes = new HashSet<String>();
            this.classesImplementingInterfaceAnnotatedWith.put(annotationName, classes);
        }
        classes.add(className);
    }

    protected Map<String, Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>>> getEnv() {
        if (this.env == null) {
            throw new IllegalArgumentException("Null env, previously serialized?");
        }
        return this.env;
    }

    public void merge(DefaultAnnotationRepository subHandle) {
        Map<String, Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>>> env = subHandle.getEnv();
        for (Map.Entry<String, Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>>> entry : env.entrySet()) {
            Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> etMap = entry.getValue();
            for (Map.Entry<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> et : etMap.entrySet()) {
                Map<ElementType, Set<ClassSignaturePair>> map = et.getValue();
                for (Map.Entry<ElementType, Set<ClassSignaturePair>> mapE : map.entrySet()) {
                    for (ClassSignaturePair csp : mapE.getValue()) {
                        this.putAnnotation(csp.getAnnotation(), et.getKey(), mapE.getKey(), csp.getClassName(), csp.getSignature(), entry.getKey());
                    }
                }
            }
        }
        for (Map.Entry<String, Object> entry : subHandle.classesImplementingInterfaceAnnotatedWith.entrySet()) {
            Set<String> mySet = this.classesImplementingInterfaceAnnotatedWith.get(entry.getKey());
            if (mySet == null) {
                mySet = new HashSet<String>();
                this.classesImplementingInterfaceAnnotatedWith.put(entry.getKey(), mySet);
            }
            mySet.addAll((Collection)entry.getValue());
        }
    }

    @Override
    boolean isAlreadyChecked(String className) {
        return this.checkedClassNames.contains(className);
    }

    @Override
    void putAnnotation(Annotation annotation, ElementType type, String className, Signature signature, URL ownerURL) {
        this.putAnnotation(annotation, annotation.annotationType(), type, className, signature, ownerURL.getPath());
    }

    void putAnnotation(Annotation annotation, Class<? extends Annotation> annClass, ElementType type, String className, Signature signature, String path) {
        Set classes;
        Map<ElementType, Set<ClassSignaturePair>> elements;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Adding annotation @" + annClass.getSimpleName() + " for " + className + " at type " + (Object)((Object)type) + ", signature: " + signature));
        }
        this.checkedClassNames.add(className);
        Map<String, Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>>> env = this.getEnv();
        Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> map = env.get(path);
        if (map == null) {
            map = new HashMap<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>>();
            env.put(path, map);
        }
        if ((elements = map.get(annClass)) == null) {
            elements = new HashMap<ElementType, Set<ClassSignaturePair>>();
            map.put(annClass, elements);
        }
        if ((classes = elements.get((Object)type)) == null) {
            classes = CollectionsFactory.createLazySet();
            elements.put(type, classes);
        }
        ClassSignaturePair pair = this.keepAnnotations ? new ClassSignaturePair(className, signature, annotation) : new ClassSignaturePair(className, signature);
        classes.add(pair);
    }

    protected Set<ClassSignaturePair> getCSPairs(String path, Class<? extends Annotation> annClass, ElementType type) {
        Set<Object> pairs = null;
        if (path == null) {
            pairs = new HashSet();
            for (Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> value : this.getEnv().values()) {
                Set<ClassSignaturePair> csps;
                Map<ElementType, Set<ClassSignaturePair>> elements = value.get(annClass);
                if (elements == null || (csps = elements.get((Object)type)) == null) continue;
                pairs.addAll(csps);
            }
        } else {
            Map<ElementType, Set<ClassSignaturePair>> elements;
            Map<Class<? extends Annotation>, Map<ElementType, Set<ClassSignaturePair>>> map = this.getEnv().get(path);
            if (map != null && (elements = map.get(annClass)) != null) {
                pairs = elements.get((Object)type);
            }
        }
        return pairs != null ? pairs : Collections.emptySet();
    }

    protected <A extends Annotation, M extends AnnotatedElement> Set<Element<A, M>> transformToElements(String path, ElementType type, Class<A> annClass, Class<M> aoClass) {
        Set<ClassSignaturePair> pairs = this.getCSPairs(path, annClass, type);
        if (pairs.isEmpty()) {
            return Collections.emptySet();
        }
        ClassLoader classLoader = this.getClassLoader();
        HashSet<Element<A, M>> elements = new HashSet<Element<A, M>>();
        for (ClassSignaturePair pair : pairs) {
            String className = pair.getClassName();
            Annotation annotation = (Annotation)annClass.cast(pair.getAnnotation());
            AbstractElement element = type == ElementType.TYPE ? new ClassElement(classLoader, className, annClass, annotation) : (type == ElementType.PARAMETER ? new ParametersElement<Annotation, M>(classLoader, className, pair.getSignature(), annClass, annotation, aoClass) : new DefaultElement<Annotation, M>(classLoader, className, pair.getSignature(), annClass, annotation, aoClass));
            elements.add(element);
        }
        return elements;
    }

    @Override
    public <A extends Annotation> Set<Element<A, AnnotatedElement>> getAnnotatedClasses(URL url, Class<A> annotation, ElementType type) {
        String path;
        String string = path = url != null ? url.getPath() : null;
        if (type == null) {
            HashSet<Element<A, AnnotatedElement>> result = new HashSet<Element<A, AnnotatedElement>>();
            result.addAll(this.transformToElements(path, ElementType.TYPE, annotation, AnnotatedElement.class));
            result.addAll(this.transformToElements(path, ElementType.CONSTRUCTOR, annotation, AnnotatedElement.class));
            result.addAll(this.transformToElements(path, ElementType.METHOD, annotation, AnnotatedElement.class));
            result.addAll(this.transformToElements(path, ElementType.FIELD, annotation, AnnotatedElement.class));
            result.addAll(this.transformToElements(path, ElementType.PARAMETER, annotation, AnnotatedElement.class));
            return result;
        }
        return this.transformToElements(path, type, annotation, AnnotatedElement.class);
    }

    @Override
    public boolean hasClassAnnotatedWith(Class<? extends Annotation> annotation) {
        return !this.getCSPairs(null, annotation, ElementType.TYPE).isEmpty();
    }

    @Override
    public <A extends Annotation> Set<Element<A, Class<?>>> classIsAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(null, ElementType.TYPE, annotation, Class.class);
    }

    @Override
    public <A extends Annotation> Set<Element<A, Constructor<?>>> classHasConstructorAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(null, ElementType.CONSTRUCTOR, annotation, Constructor.class);
    }

    @Override
    public <A extends Annotation> Set<Element<A, Field>> classHasFieldAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(null, ElementType.FIELD, annotation, Field.class);
    }

    @Override
    public <A extends Annotation> Set<Element<A, Method>> classHasMethodAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(null, ElementType.METHOD, annotation, Method.class);
    }

    @Override
    public <A extends Annotation> Set<Element<A, AnnotatedElement>> classHasParameterAnnotatedWith(Class<A> annotation) {
        return this.transformToElements(null, ElementType.PARAMETER, annotation, AnnotatedElement.class);
    }

    protected Class<Annotation> getAnnotationClass(String annotationName) {
        Class clazz = this.loadClass(annotationName);
        if (!Annotation.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Annotation name " + annotationName + " doesn't extend Annotation class.");
        }
        return clazz;
    }

    @Override
    public boolean hasClassAnnotatedWith(String annotationName) {
        return this.hasClassAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    @Override
    public Set<Element<Annotation, Class<?>>> classIsAnnotatedWith(String annotationName) {
        return this.classIsAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    @Override
    public Set<Element<Annotation, Constructor<?>>> classHasConstructorAnnotatedWith(String annotationName) {
        return this.classHasConstructorAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    @Override
    public Set<Element<Annotation, Field>> classHasFieldAnnotatedWith(String annotationName) {
        return this.classHasFieldAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    @Override
    public Set<Element<Annotation, Method>> classHasMethodAnnotatedWith(String annotationName) {
        return this.classHasMethodAnnotatedWith(this.getAnnotationClass(annotationName));
    }

    @Override
    public Set<Element<Annotation, AnnotatedElement>> classHasParameterAnnotatedWith(String annotationName) {
        return this.classHasParameterAnnotatedWith(this.getAnnotationClass(annotationName));
    }
}

