/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.weld;

import java.net.URL;
import java.util.Collection;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.plugins.DeploymentScanningPluginFactory;
import org.jboss.scanning.plugins.helpers.VoidScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.deployer.env.WeldDiscoveryEnvironment;

/**
 * Add Weld scanning plugin.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class WeldScanningPluginFactory implements DeploymentScanningPluginFactory<VoidScanningHandle, Object>
{
   public boolean isRelevant(DeploymentUnit unit)
   {
      @SuppressWarnings("unchecked")
      Collection<VirtualFile> wbFiles = unit.getAttachment(DeployersUtils.WELD_FILES, Collection.class);
      boolean hasWB = (wbFiles != null && wbFiles.isEmpty() == false);

      @SuppressWarnings("unchecked")
      Collection<VirtualFile> cpFiles = unit.getAttachment(DeployersUtils.WELD_CLASSPATH, Collection.class);
      boolean hasCp = (cpFiles != null && cpFiles.isEmpty() == false);

      if (hasWB || hasCp)
      {
         DeploymentUnit topUnit = unit.getTopLevel();
         WeldDiscoveryEnvironment environment = topUnit.getAttachment(WeldDiscoveryEnvironment.class);
         if (environment == null)
         {
            environment = new WeldDiscoveryEnvironment();
            topUnit.addAttachment(WeldDiscoveryEnvironment.class, environment);
         }

         if (hasWB)
         {
            // TODO -- fix this once we have new Weld-int release
            Collection<URL> xmls = environment.getWeldXml();
            try
            {
               for (VirtualFile file : wbFiles)
                  xmls.add(file.toURL());
            }
            catch (Exception e)
            {
               throw new RuntimeException(e);
            }
         }
      }

      return hasCp;
   }

   public String getPluginOutput()
   {
      return null; // no such attachment / output
   }

   public ScanningPlugin<VoidScanningHandle, Object> create(DeploymentUnit unit)
   {
      @SuppressWarnings("unchecked")
      Collection<VirtualFile> cpFiles = unit.getAttachment(DeployersUtils.WELD_CLASSPATH, Collection.class);
      WeldDiscoveryEnvironment environment = unit.getTopLevel().getAttachment(WeldDiscoveryEnvironment.class);
      return new WeldScanningPlugin(environment, cpFiles);
   }
}
