/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.annotations.plugins;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.plugins.DeploymentScanningPluginFactory;
import org.jboss.scanning.plugins.helpers.DeploymentUtilsFactory;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.visitor.ErrorHandler;
import org.jboss.scanning.plugins.visitor.ReflectProvider;
import org.jboss.scanning.spi.ScanningPlugin;

/**
 * Annotations scanning plugin factory.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class AnnotationsScanningPluginFactory implements DeploymentScanningPluginFactory<DefaultAnnotationRepository, AnnotationIndex>
{
   public boolean isRelevant(DeploymentUnit unit)
   {
      // any better check? -- metadata complete is already done elsewhere
      // see JBossMetaDataDeploymentUnitFilter in JBossAS
      return true;
   }

   public String getPluginOutput()
   {
      return AnnotationIndex.class.getName();
   }

   public ScanningPlugin<DefaultAnnotationRepository, AnnotationIndex> create(DeploymentUnit unit)
   {
      ReflectProvider provider = DeploymentUtilsFactory.getProvider(unit);
      ResourceOwnerFinder finder = DeploymentUtilsFactory.getFinder(unit);
      ErrorHandler handler = DeploymentUtilsFactory.getHandler(unit);
      return new AnnotationsScanningPlugin(provider, finder, unit.getClassLoader(), handler);
   }
}