/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.annotations.plugins;

import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.plugins.helpers.ClassResourceOwnerFinder;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.visitor.ErrorHandler;
import org.jboss.scanning.plugins.visitor.IntrospectionReflectProvider;
import org.jboss.scanning.plugins.visitor.ReflectProvider;
import org.jboss.scanning.spi.helpers.AbstractClassLoadingScanningPlugin;

/**
 * Annotations scanning plugin.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class AnnotationsScanningPlugin extends AbstractClassLoadingScanningPlugin<DefaultAnnotationRepository, AnnotationIndex>
{
   /** The repository */
   private final DefaultAnnotationRepository repository;
   /** The annotations visitor */
   private final GenericAnnotationVisitor visitor;

   public AnnotationsScanningPlugin(ClassLoader cl)
   {
      this(IntrospectionReflectProvider.INSTANCE, ClassResourceOwnerFinder.INSTANCE, cl, null);
   }

   public AnnotationsScanningPlugin(ReflectProvider provider, ResourceOwnerFinder finder, ClassLoader cl, ErrorHandler handler)
   {
      repository = new DefaultAnnotationRepository(cl);
      // setup annotations visitor
      visitor = new GenericAnnotationVisitor(provider, finder, repository);
      visitor.setErrorHandler(handler);
   }

   protected DefaultAnnotationRepository doCreateHandle()
   {
      return repository;
   }

   protected ClassLoader getClassLoader()
   {
      return repository.getClassLoader();
   }

   @Override
   public void cleanupHandle(AnnotationIndex handle)
   {
      if (handle instanceof DefaultAnnotationRepository)
         DefaultAnnotationRepository.class.cast(handle).cleanup();
   }

   public Class<AnnotationIndex> getHandleInterface()
   {
      return AnnotationIndex.class;
   }

   public ResourceFilter getFilter()
   {
      return visitor.getFilter();
   }

   public void visit(ResourceContext resource)
   {
      visitor.visit(resource);
   }
}
