/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.helpers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.jboss.deployers.spi.deployer.helpers.AttachmentLocator;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LazyUtilsProxyHandler<T>
implements InvocationHandler {
    private DeploymentUnit unit;
    private Class<T> type;
    private T util;

    public LazyUtilsProxyHandler(DeploymentUnit unit, Class<T> type) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        if (type == null) {
            throw new IllegalArgumentException("Null util type");
        }
        this.unit = unit;
        this.type = type;
    }

    private T getUtil() {
        if (this.util == null) {
            Object tmp = AttachmentLocator.searchAncestors((DeploymentUnit)this.unit, this.type);
            if (tmp == null) {
                throw new IllegalArgumentException("No such util: " + this.type);
            }
            this.util = tmp;
        }
        return this.util;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke(this.getUtil(), args);
    }
}

