/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactoryMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.xml.sax.Attributes;

public class BeanFactoryHandler
extends DefaultElementHandler {
    public static final BeanFactoryHandler HANDLER = new BeanFactoryHandler();

    public Object startElement(Object parent, QName name, ElementBinding element) {
        return new GenericBeanFactoryMetaData();
    }

    public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
        GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)o;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String localName = attrs.getLocalName(i);
            if ("name".equals(localName)) {
                bean.setName(attrs.getValue(i));
                continue;
            }
            if ("class".equals(localName)) {
                bean.setBeanClass(attrs.getValue(i));
                continue;
            }
            if ("factoryClass".equals(localName)) {
                bean.setFactoryClass(attrs.getValue(i));
                continue;
            }
            if ("mode".equals(localName)) {
                bean.setMode(ControllerMode.getInstance((String)attrs.getValue(i)));
                continue;
            }
            if (!"access-mode".equals(localName)) continue;
            BeanAccessMode mode = BeanAccessMode.STANDARD;
            if ("fields".equalsIgnoreCase(localName)) {
                mode = BeanAccessMode.FIELDS;
            } else if ("all".equalsIgnoreCase(localName)) {
                mode = BeanAccessMode.ALL;
            }
            bean.setAccessMode(mode);
        }
    }

    public Object endElement(Object o, QName qName, ElementBinding element) {
        GenericBeanFactoryMetaData bean = (GenericBeanFactoryMetaData)o;
        if (bean.getBeanClass() == null) {
            PropertyMetaData property = bean.getProperty("constructor");
            if (property == null) {
                throw new IllegalArgumentException("BeanFactory should have a class attribute or a constructor element.");
            }
            ValueMetaData value = property.getValue();
            if (value == null) {
                throw new IllegalArgumentException("BeanFactory should have a class attribute or a constructor element.");
            }
            ConstructorMetaData constructor = (ConstructorMetaData)value.getUnderlyingValue();
            if (constructor == null) {
                throw new IllegalArgumentException("BeanFactory should have a class attribute or a constructor element.");
            }
            if (constructor.getFactoryMethod() == null) {
                throw new IllegalArgumentException("BeanFactory should have a class attribute or the constructor element should have a factoryMethod attribute.");
            }
            if (constructor.getFactory() == null && constructor.getFactoryClass() == null) {
                throw new IllegalArgumentException("BeanFactory should have a class attribute or the constructor element should have a either a factoryClass attribute or a factory element.");
            }
        }
        return bean;
    }
}

