/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.spi;

import org.jboss.util.JBossStringBuilder;
import org.jboss.xb.annotations.JBossXmlEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JBossXmlEnum(ignoreCase=true)
public enum ControllerMode {
    AUTOMATIC("Automatic"),
    ON_DEMAND("On Demand"),
    MANUAL("Manual"),
    DISABLED("Disabled"),
    ASYNCHRONOUS("Asynchronous");

    private final String modeString;

    private ControllerMode(String modeString) {
        if (modeString == null) {
            throw new IllegalArgumentException("Null mode string");
        }
        this.modeString = modeString;
    }

    public static ControllerMode getInstance(String modeString) {
        if (modeString == null) {
            throw new IllegalArgumentException("Null mode string.");
        }
        for (ControllerMode cm : ControllerMode.values()) {
            if (!modeString.equalsIgnoreCase(cm.getModeString())) continue;
            return cm;
        }
        throw new IllegalArgumentException("No such controller mode: " + modeString);
    }

    public String getModeString() {
        return this.modeString;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append(this.modeString);
    }
}

