/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jdeparser.JAssignmentTarget;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JConditional;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExpression;
import org.jboss.jdeparser.JFieldVar;
import org.jboss.jdeparser.JInvocation;
import org.jboss.jdeparser.JMethod;
import org.jboss.jdeparser.JStatement;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JVar;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ThrowableType;

abstract class ImplementationClassModel
extends ClassModel {
    ImplementationClassModel(MessageInterface messageInterface) {
        super(messageInterface, ClassModelHelper.implementationClassName(messageInterface), null);
    }

    @Override
    protected JDeparser generateModel() throws IllegalStateException {
        JDeparser codeModel = super.generateModel();
        this.getDefinedClass()._implements(codeModel.directClass(Serializable.class.getName()));
        JFieldVar serialVersionUID = this.getDefinedClass().field(28, (JType)codeModel.LONG, "serialVersionUID");
        serialVersionUID.init(JExpr.lit((long)1L));
        return codeModel;
    }

    void createBundleMethod(MessageMethod messageMethod, JMethod method, JMethod msgMethod) {
        JInvocation expression;
        JInvocation formatterMethod;
        this.addThrownTypes(messageMethod, method);
        JBlock body = method.body();
        JClass returnField = this.getCodeModel().directClass(method.type().fullName());
        MessageMethod.Message message = messageMethod.message();
        boolean noFormatParameters = messageMethod.parameters(Parameter.ParameterType.FORMAT).isEmpty();
        switch (message.format()) {
            case MESSAGE_FORMAT: {
                JClass formatter = this.getCodeModel().directClass(message.format().formatClass().getName());
                formatterMethod = formatter.staticInvoke(message.format().staticMethod());
                if (noFormatParameters) {
                    expression = JExpr.invoke((JMethod)msgMethod);
                    break;
                }
                formatterMethod.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
                expression = formatterMethod;
                break;
            }
            case PRINTF: {
                JClass formatter = this.getCodeModel().directClass(message.format().formatClass().getName());
                expression = formatterMethod = formatter.staticInvoke(message.format().staticMethod()).arg((JExpression)JExpr.invoke((JMethod)msgMethod));
                break;
            }
            default: {
                formatterMethod = null;
                expression = JExpr.invoke((JMethod)msgMethod);
            }
        }
        Set<Parameter> allParameters = messageMethod.parameters(Parameter.ParameterType.ANY);
        LinkedHashMap<String, JVar> fields = new LinkedHashMap<String, JVar>();
        LinkedHashMap<String, JVar> properties = new LinkedHashMap<String, JVar>();
        ArrayList<String> parameterNames = new ArrayList<String>(allParameters.size());
        for (Parameter param : allParameters) {
            parameterNames.add(param.name());
        }
        ArrayList<Object> args = new ArrayList<Object>();
        block12: for (Parameter parameter : allParameters) {
            JClass paramType = parameter.isArray() && !parameter.isVarArgs() ? this.getCodeModel().directClass(parameter.type()).array() : this.getCodeModel().directClass(parameter.type());
            JVar var = parameter.isVarArgs() ? method.varParam((JType)paramType, parameter.name()) : method.param(8, (JType)paramType, parameter.name());
            String formatterClass = parameter.formatterClass();
            switch (parameter.parameterType()) {
                case FORMAT: {
                    if (formatterMethod == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    if (formatterClass == null) {
                        if (parameter.isArray() || parameter.isVarArgs()) {
                            args.add(this.getCodeModel().directClass(Arrays.class.getName()).staticInvoke("toString").arg((JExpression)var));
                            break;
                        }
                        args.add(var);
                        break;
                    }
                    args.add(JExpr._new((JClass)this.getCodeModel().directClass(formatterClass)).arg((JExpression)var));
                    break;
                }
                case TRANSFORM: {
                    if (formatterMethod == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    JVar transformVar = this.createTransformVar(parameterNames, body, parameter, var);
                    if (formatterClass == null) {
                        args.add(transformVar);
                        break;
                    }
                    JInvocation invocation = JExpr._new((JClass)this.getCodeModel().directClass(formatterClass));
                    args.add(invocation.arg((JExpression)transformVar));
                    break;
                }
                case POS: {
                    if (formatterMethod == null) {
                        throw new IllegalStateException("No format parameters are allowed when NO_FORMAT is specified.");
                    }
                    Pos pos = parameter.pos();
                    int[] positions = pos.value();
                    Transform[] transform = pos.transform();
                    for (int i = 0; i < positions.length; ++i) {
                        int index = positions[i] - 1;
                        if (transform != null && transform.length > 0) {
                            JVar tVar = this.createTransformVar(parameterNames, method.body(), parameter, transform[i], var);
                            if (index < args.size()) {
                                args.add(index, tVar);
                                continue;
                            }
                            args.add(tVar);
                            continue;
                        }
                        if (index < args.size()) {
                            args.add(index, var);
                            continue;
                        }
                        args.add(var);
                    }
                    continue block12;
                }
                case FIELD: {
                    fields.put(parameter.targetName(), var);
                    break;
                }
                case PROPERTY: {
                    properties.put(parameter.targetName(), var);
                }
            }
        }
        if (formatterMethod != null) {
            for (JExpression jExpression : args) {
                formatterMethod.arg(jExpression);
            }
        }
        JVar result = body.decl((JType)returnField, "result");
        if (messageMethod.returnType().isThrowable()) {
            this.initCause(result, returnField, body, messageMethod, (JExpression)expression);
        } else {
            result.init((JExpression)expression);
        }
        for (Map.Entry entry : fields.entrySet()) {
            body.assign((JAssignmentTarget)result.ref((String)entry.getKey()), (JExpression)entry.getValue());
        }
        for (Map.Entry entry : properties.entrySet()) {
            body.add((JStatement)result.invoke((String)entry.getKey()).arg((JExpression)entry.getValue()));
        }
        body._return((JExpression)result);
    }

    JVar createTransformVar(List<String> parameterNames, JBlock methodBody, Parameter param, JVar var) {
        return this.createTransformVar(parameterNames, methodBody, param, param.transform(), var);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JVar createTransformVar(List<String> parameterNames, JBlock methodBody, Parameter param, Transform transform, JVar var) {
        JVar result;
        int currentPos = methodBody.pos();
        methodBody.pos(0);
        List<Transform.TransformType> transformTypes = Arrays.asList(transform.value());
        JConditional condition = methodBody._if(var.eq(JExpr._null()));
        JBlock ifBlock = condition._then();
        JBlock elseBlock = condition._else();
        methodBody.pos(0);
        if (transformTypes.contains(Transform.TransformType.GET_CLASS)) {
            if (transformTypes.size() == 1) {
                String paramName = this.getUniqueName(parameterNames, param, "Class");
                parameterNames.add(paramName);
                result = methodBody.decl((JType)this.getCodeModel().directClass("java.lang.Class"), paramName);
                ifBlock.assign((JAssignmentTarget)result, JExpr._null());
                elseBlock.assign((JAssignmentTarget)result, (JExpression)var.invoke("getClass"));
            } else {
                String paramName = this.getUniqueName(parameterNames, param, "HashCode");
                parameterNames.add(paramName);
                result = methodBody.decl((JType)this.getCodeModel().INT, paramName);
                ifBlock.assign((JAssignmentTarget)result, JExpr.lit((int)0));
                if (transformTypes.contains(Transform.TransformType.HASH_CODE)) {
                    elseBlock.assign((JAssignmentTarget)result, (JExpression)var.invoke("getClass").invoke("hashCode"));
                } else {
                    if (!transformTypes.contains(Transform.TransformType.IDENTITY_HASH_CODE)) throw new IllegalStateException(String.format("Invalid transform type combination: %s", transformTypes));
                    elseBlock.assign((JAssignmentTarget)result, (JExpression)this.getCodeModel().directClass("java.lang.System").staticInvoke("identityHashCode").arg((JExpression)var.invoke("getClass")));
                }
            }
        } else if (transformTypes.contains(Transform.TransformType.HASH_CODE)) {
            String paramName = this.getUniqueName(parameterNames, param, "HashCode");
            parameterNames.add(paramName);
            result = methodBody.decl((JType)this.getCodeModel().INT, paramName);
            ifBlock.assign((JAssignmentTarget)result, JExpr.lit((int)0));
            if (param.isArray() || param.isVarArgs()) {
                elseBlock.assign((JAssignmentTarget)result, (JExpression)this.getCodeModel().directClass(Arrays.class.getName()).staticInvoke("hashCode").arg((JExpression)var));
            } else {
                elseBlock.assign((JAssignmentTarget)result, (JExpression)var.invoke("hashCode"));
            }
        } else if (transformTypes.contains(Transform.TransformType.IDENTITY_HASH_CODE)) {
            String paramName = this.getUniqueName(parameterNames, param, "HashCode");
            parameterNames.add(paramName);
            result = methodBody.decl((JType)this.getCodeModel().INT, paramName);
            ifBlock.assign((JAssignmentTarget)result, JExpr.lit((int)0));
            elseBlock.assign((JAssignmentTarget)result, (JExpression)this.getCodeModel().directClass("java.lang.System").staticInvoke("identityHashCode").arg((JExpression)var));
        } else {
            if (!transformTypes.contains(Transform.TransformType.SIZE)) throw new IllegalStateException(String.format("Invalid transform type: %s", transformTypes));
            String paramName = this.getUniqueName(parameterNames, param, "Size");
            parameterNames.add(paramName);
            result = methodBody.decl((JType)this.getCodeModel().INT, paramName);
            ifBlock.assign((JAssignmentTarget)result, JExpr.lit((int)0));
            if (param.isArray() || param.isVarArgs()) {
                elseBlock.assign((JAssignmentTarget)result, (JExpression)var.ref("length"));
            } else if (param.isSubtypeOf(Map.class) || param.isSubtypeOf(Collection.class)) {
                elseBlock.assign((JAssignmentTarget)result, (JExpression)var.invoke("size"));
            } else {
                if (!param.isSubtypeOf(CharSequence.class)) throw new IllegalStateException(String.format("Invalid type for %s. Must be an array, %s, %s or %s.", Transform.TransformType.SIZE, Collection.class.getName(), Map.class.getName(), CharSequence.class.getName()));
                elseBlock.assign((JAssignmentTarget)result, (JExpression)var.invoke("length"));
            }
        }
        methodBody.pos(currentPos + 2);
        return result;
    }

    private String getUniqueName(List<String> parameterNames, Parameter parameter, String suffix) {
        String result;
        String string = result = suffix == null ? parameter.name() : parameter.name().concat(suffix);
        if (parameterNames.contains(result)) {
            return this.getUniqueName(parameterNames, new StringBuilder(result), 0);
        }
        return result;
    }

    private String getUniqueName(List<String> parameterNames, StringBuilder sb, int index) {
        String result = sb.append(index).toString();
        if (parameterNames.contains(result)) {
            return this.getUniqueName(parameterNames, sb, index + 1);
        }
        return result;
    }

    private void initCause(JVar result, JClass returnField, JBlock body, MessageMethod messageMethod, JExpression format) {
        JInvocation initCause;
        ThrowableType returnType = messageMethod.returnType().throwableReturnType();
        if (returnType.useConstructionParameters()) {
            JInvocation invocation = JExpr._new((JClass)returnField);
            block3: for (Parameter param : returnType.constructionParameters()) {
                switch (param.parameterType()) {
                    case MESSAGE: {
                        invocation.arg(format);
                        continue block3;
                    }
                }
                invocation.arg((JExpression)JExpr.ref((String)param.name()));
            }
            result.init((JExpression)invocation);
        } else if (returnType.hasStringAndThrowableConstructor() && messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(format).arg((JExpression)JExpr.ref((String)messageMethod.cause().name())));
        } else if (returnType.hasThrowableAndStringConstructor() && messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)JExpr.ref((String)messageMethod.cause().name())).arg(format));
        } else if (returnType.hasStringConstructor()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(format));
            if (messageMethod.hasCause()) {
                initCause = body.invoke((JExpression)result, "initCause");
                initCause.arg((JExpression)JExpr.ref((String)messageMethod.cause().name()));
            }
        } else if (returnType.hasThrowableConstructor() && messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg((JExpression)JExpr.ref((String)messageMethod.cause().name())));
        } else if (returnType.hasStringAndThrowableConstructor() && !messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(format).arg(JExpr._null()));
        } else if (returnType.hasThrowableAndStringConstructor() && !messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField).arg(JExpr._null()).arg(format));
        } else if (messageMethod.hasCause()) {
            result.init((JExpression)JExpr._new((JClass)returnField));
            initCause = body.invoke((JExpression)result, "initCause");
            initCause.arg((JExpression)JExpr.ref((String)messageMethod.cause().name()));
        } else {
            result.init((JExpression)JExpr._new((JClass)returnField));
        }
        JClass arrays = this.getCodeModel().directClass(Arrays.class.getName());
        JClass stClass = this.getCodeModel().directClass(StackTraceElement.class.getName()).array();
        JVar st = body.decl((JType)stClass, "st").init((JExpression)result.invoke("getStackTrace"));
        JInvocation setStackTrace = result.invoke("setStackTrace");
        setStackTrace.arg((JExpression)arrays.staticInvoke("copyOfRange").arg((JExpression)st).arg(JExpr.lit((int)1)).arg((JExpression)st.ref("length")));
        body.add((JStatement)setStackTrace);
    }

    protected final void addThrownTypes(MessageMethod messageMethod, JMethod jMethod) {
        for (ThrowableType thrownType : messageMethod.thrownTypes()) {
            jMethod._throws(this.getCodeModel().directClass(thrownType.name()));
        }
    }
}

