/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JDefinedClass;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JMethod;
import org.jboss.logging.processor.Tools;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;

class MessageLoggerTranslator
extends ClassModel {
    private static final String LOGGER_PARAMETER_NAME = "logger";
    private final Map<MessageMethod, String> translations;

    public MessageLoggerTranslator(MessageInterface messageInterface, String className, String superClassName, Map<MessageMethod, String> translations) {
        super(messageInterface, className, superClassName);
        this.translations = translations != null ? translations : Collections.emptyMap();
    }

    @Override
    public JDeparser generateModel() throws IllegalStateException {
        JDeparser model = super.generateModel();
        JDefinedClass definedClass = this.getDefinedClass();
        JMethod constructor = definedClass.constructor(1);
        constructor.param(8, Tools.loggers().loggerClass(), LOGGER_PARAMETER_NAME);
        JBlock constructorBody = constructor.body();
        constructorBody.directStatement("super(logger);");
        Set<Map.Entry<MessageMethod, String>> entries = this.translations.entrySet();
        HashSet<String> methodNames = new HashSet<String>();
        for (Map.Entry<MessageMethod, String> entry : entries) {
            JMethod method = this.addMessageMethod(entry.getKey(), entry.getValue());
            if (!methodNames.add(method.name())) continue;
            method.annotate(Override.class);
        }
        return model;
    }
}

