/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.spi.annotations;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.kernel.plugins.annotations.BasicBeanMetaDataAnnotationAdapter;
import org.jboss.kernel.spi.annotations.BeanMetaDataAnnotationAdapter;
import org.jboss.metadata.plugins.loader.reflection.AnnotatedElementMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalToMetaDataBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationToBeanMetaDataFactory {
    private static Configuration configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

        @Override
        public Configuration run() {
            return new PropertyConfiguration();
        }
    });

    public static BeanMetaData createBeanMetaData(Class<?> beanClass) throws Throwable {
        return AnnotationToBeanMetaDataFactory.fillBeanMetaData(beanClass, null);
    }

    public static BeanMetaData createBeanMetaData(Class<?> beanClass, BeanAccessMode mode) throws Throwable {
        return AnnotationToBeanMetaDataFactory.fillBeanMetaData(beanClass, mode, null);
    }

    public static BeanMetaData createBeanMetaData(Class<?> beanClass, MetaData metaData) throws Throwable {
        return AnnotationToBeanMetaDataFactory.fillBeanMetaData(beanClass, metaData, null, null);
    }

    public static BeanMetaData createBeanMetaData(Class<?> beanClass, BeanMetaDataAnnotationAdapter adapter) throws Throwable {
        return AnnotationToBeanMetaDataFactory.fillBeanMetaData(beanClass, null, adapter);
    }

    public static BeanMetaData createBeanMetaData(Class<?> beanClass, BeanAccessMode mode, BeanMetaDataAnnotationAdapter adapter) throws Throwable {
        return AnnotationToBeanMetaDataFactory.fillBeanMetaData(beanClass, mode, null, null, adapter);
    }

    public static BeanMetaData fillBeanMetaData(Class<?> beanClass, BeanMetaData existingMetaData) throws Throwable {
        return AnnotationToBeanMetaDataFactory.fillBeanMetaData(beanClass, existingMetaData, null);
    }

    public static BeanMetaData fillBeanMetaData(Class<?> beanClass, BeanAccessMode mode, BeanMetaData existingMetaData) throws Throwable {
        return AnnotationToBeanMetaDataFactory.fillBeanMetaData(beanClass, mode, null, existingMetaData, null);
    }

    public static BeanMetaData fillBeanMetaData(Class<?> beanClass, BeanMetaData existingMetaData, BeanMetaDataAnnotationAdapter adapter) throws Throwable {
        return AnnotationToBeanMetaDataFactory.fillBeanMetaData(beanClass, null, null, existingMetaData, adapter);
    }

    public static BeanMetaData fillBeanMetaData(Class<?> beanClass, BeanAccessMode mode, BeanMetaData existingMetaData, BeanMetaDataAnnotationAdapter adapter) throws Throwable {
        return AnnotationToBeanMetaDataFactory.fillBeanMetaData(beanClass, mode, null, existingMetaData, adapter);
    }

    public static BeanMetaData fillBeanMetaData(Class<?> beanClass, MetaData metaData, BeanMetaData existingMetaData, BeanMetaDataAnnotationAdapter adapter) throws Throwable {
        return AnnotationToBeanMetaDataFactory.fillBeanMetaData(beanClass, null, metaData, existingMetaData, adapter);
    }

    public static BeanMetaData fillBeanMetaData(Class<?> beanClass, BeanAccessMode mode, MetaData metaData, BeanMetaData existingMetaData, BeanMetaDataAnnotationAdapter adapter) throws Throwable {
        if (beanClass == null) {
            throw new IllegalArgumentException("Null bean class");
        }
        if (mode == null) {
            mode = BeanAccessMode.STANDARD;
        }
        if (metaData == null) {
            AnnotatedElementMetaDataLoader retrieval = new AnnotatedElementMetaDataLoader(beanClass);
            metaData = new MetaDataRetrievalToMetaDataBridge((MetaDataRetrieval)retrieval);
        }
        if (existingMetaData == null) {
            AbstractBeanMetaData abmd = new AbstractBeanMetaData();
            abmd.setBean(beanClass.getName());
            abmd.setAccessMode(mode);
            existingMetaData = abmd;
        } else {
            BeanAccessMode bam = existingMetaData.getAccessMode();
            if (bam == null) {
                if (!(existingMetaData instanceof AbstractBeanMetaData)) {
                    throw new IllegalArgumentException("Can only apply BeanAccessMode to AbstractBeanMetaData: " + existingMetaData);
                }
                AbstractBeanMetaData abmd = (AbstractBeanMetaData)AbstractBeanMetaData.class.cast(existingMetaData);
                abmd.setAccessMode(mode);
            } else if (bam != mode) {
                throw new IllegalArgumentException("Different bean access modes: " + bam + " != " + mode);
            }
        }
        if (adapter == null) {
            adapter = BasicBeanMetaDataAnnotationAdapter.INSTANCE;
        }
        BeanInfo beanInfo = configuration.getBeanInfo(beanClass, mode);
        adapter.applyAnnotations(beanInfo, metaData, existingMetaData);
        return existingMetaData;
    }
}

