/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.List;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AnnotationsAction;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.dependency.DependencyBuilder;
import org.jboss.kernel.spi.dependency.DependencyBuilderListItem;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.MetaData;

public class DescribeAction
extends AnnotationsAction {
    protected void installActionInternal(KernelControllerContext context) throws Throwable {
        BeanInfo info = context.getBeanInfo();
        if (info != null) {
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelMetaDataRepository repository = kernel.getMetaDataRepository();
            MetaData md = repository.getMetaData(context);
            KernelConfig config = kernel.getConfig();
            DependencyBuilder dependencyBuilder = config.getDependencyBuilder();
            List<DependencyBuilderListItem> dependencies = dependencyBuilder.getDependencies(info, md);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Extra dependencies for " + context.getName() + " " + dependencies));
            }
            if (dependencies != null && !dependencies.isEmpty()) {
                for (DependencyBuilderListItem dependencyItem : dependencies) {
                    dependencyItem.addDependency(context);
                }
            }
            this.applyAnnotations(context);
        }
    }

    protected void uninstallActionInternal(KernelControllerContext context) {
        BeanInfo info = context.getBeanInfo();
        if (info != null) {
            DependencyBuilder dependencyBuilder;
            this.cleanAnnotations(context);
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelMetaDataRepository repository = kernel.getMetaDataRepository();
            MetaData md = repository.getMetaData(context);
            try {
                KernelConfig config = kernel.getConfig();
                dependencyBuilder = config.getDependencyBuilder();
            }
            catch (Throwable e) {
                this.log.debug((Object)("Error while cleaning the annotations: " + e));
                return;
            }
            List<DependencyBuilderListItem> dependencies = dependencyBuilder.getDependencies(info, md);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Unwind extra dependencies for " + context.getName() + " " + dependencies));
            }
            if (dependencies != null && !dependencies.isEmpty()) {
                for (DependencyBuilderListItem dependencyItem : dependencies) {
                    dependencyItem.removeDependency(context);
                }
            }
        }
    }

    protected ControllerState getState() {
        return ControllerState.DESCRIBED;
    }
}

