/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.deployers;

import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.logging.Logger;
import org.jboss.profileservice.deployment.hotdeploy.ProfileDeploymentModificationChecker;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.vfs.VirtualFile;

public class DelegateModificationChecker
implements ProfileDeploymentModificationChecker {
    private static final Logger log = Logger.getLogger(ProfileDeploymentModificationChecker.class);
    private StructureModificationChecker delegate;

    public StructureModificationChecker getModificationChecker() {
        return this.delegate;
    }

    public void setModificationChecker(StructureModificationChecker delegate) {
        this.delegate = delegate;
    }

    public boolean isDeploymentModified(ProfileDeployment deployment, VirtualFile deploymentRoot) {
        if (this.getModificationChecker() == null) {
            return false;
        }
        try {
            String deploymentName = deployment.getName();
            return this.delegate.hasStructureBeenModified(deploymentName, deploymentRoot);
        }
        catch (Exception e) {
            log.trace((Object)"failed to check structure", (Throwable)e);
            return false;
        }
    }

    public void removed(ProfileDeployment deployment, VirtualFile deploymentRoot) {
        this.delegate.removeStructureRoot(deploymentRoot);
    }
}

