/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.protocol;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.virtual.plugins.vfs.VirtualFileURLConnection;

public abstract class AbstractVFSHandler
extends URLStreamHandler {
    private static Map<Class, Integer> lengths = new WeakHashMap<Class, Integer>();

    protected int getProtocolNameLength() {
        Class<?> clazz = this.getClass();
        Integer length = lengths.get(clazz);
        if (length == null) {
            Package pck = clazz.getPackage();
            String pckName = pck.getName();
            int p = pckName.lastIndexOf(46);
            length = pckName.substring(p + 1).length();
            lengths.put(clazz, length);
        }
        return length;
    }

    protected URLConnection openConnection(URL url) throws IOException {
        String relative;
        String file = url.toExternalForm().substring(this.getProtocolNameLength() + 1);
        URL vfsurl = null;
        File fp = new File(file);
        if (fp.exists()) {
            vfsurl = fp.getParentFile().toURL();
            relative = fp.getName();
        } else {
            File curr = fp;
            relative = fp.getName();
            while ((curr = curr.getParentFile()) != null) {
                if (curr.exists()) {
                    vfsurl = curr.toURL();
                    break;
                }
                relative = curr.getName() + "/" + relative;
            }
        }
        if (vfsurl == null) {
            throw new IOException("VFS file does not exist: " + url);
        }
        return new VirtualFileURLConnection(url, vfsurl, relative);
    }
}

