/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.metadata.plugins.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Simple map backed-up cache.
 *
 * @param <K> the key class
 * @param <V> the value class
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class ConcurrentHashMapCache<K, V> implements Cache<K, V>
{
   private Map<K, V> map = new ConcurrentHashMap<K,V>();

   public V put(K key, V value)
   {
      return map.put(key, value);
   }

   public V get(K key)
   {
      return map.get(key);
   }

   public V remove(K key)
   {
      return map.remove(key);
   }

   public void clear()
   {
      map.clear();
   }
}
