/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.jboss.forge.addon.resource.FileOperations;
import org.jboss.forge.furnace.util.Streams;

public enum DefaultFileOperations implements FileOperations
{
    INSTANCE;


    @Override
    public boolean fileExists(File f) {
        return f.exists();
    }

    @Override
    public boolean fileExistsAndIsDirectory(File f) {
        return f.isDirectory();
    }

    @Override
    public File[] listFiles(File f) {
        return f.listFiles();
    }

    @Override
    public long getFileLength(File f) {
        return f.length();
    }

    @Override
    public boolean deleteFile(File file) {
        return file.delete();
    }

    @Override
    public void deleteFileOnExit(File file) {
        file.deleteOnExit();
    }

    @Override
    public boolean createNewFile(File file) throws IOException {
        return file.createNewFile();
    }

    @Override
    public boolean mkdir(File file) {
        return file.mkdir();
    }

    @Override
    public boolean mkdirs(File file) {
        return file.mkdirs();
    }

    @Override
    public OutputStream createOutputStream(File file) throws IOException {
        return new FileOutputStream(file);
    }

    @Override
    public InputStream createInputStream(File file) throws IOException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    @Override
    public boolean renameFile(File srcFile, File destFile) {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        return srcFile.renameTo(destFile);
    }

    @Override
    public void copyFile(File srcFile, File destFile) throws IOException {
        if (srcFile == null) {
            throw new NullPointerException("Source must not be null");
        }
        if (destFile == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (!srcFile.exists()) {
            throw new FileNotFoundException("Source '" + srcFile + "' does not exist");
        }
        if (srcFile.isDirectory()) {
            throw new IOException("Source '" + srcFile + "' exists but is a directory");
        }
        if (srcFile.getCanonicalPath().equals(destFile.getCanonicalPath())) {
            throw new IOException("Source '" + srcFile + "' and destination '" + destFile + "' are the same");
        }
        if (destFile.getParentFile() != null && !destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            throw new IOException("Destination '" + destFile + "' directory cannot be created");
        }
        if (destFile.exists() && !destFile.canWrite()) {
            throw new IOException("Destination '" + destFile + "' exists but is read-only");
        }
        this.doCopyFile(srcFile, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            long count = 0L;
            long FIFTY_MB = 0x3200000L;
            for (long pos = 0L; pos < size; pos += output.transferFrom(input, pos, count)) {
                count = size - pos > FIFTY_MB ? FIFTY_MB : size - pos;
            }
        }
        catch (Throwable throwable) {
            Streams.closeQuietly(output);
            Streams.closeQuietly(fos);
            Streams.closeQuietly(input);
            Streams.closeQuietly((Closeable)fis);
            throw throwable;
        }
        Streams.closeQuietly((Closeable)output);
        Streams.closeQuietly((Closeable)fos);
        Streams.closeQuietly((Closeable)input);
        Streams.closeQuietly((Closeable)fis);
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "'");
        }
    }
}

